package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ApplicationFolderQuery extends Query<ApplicationFolder> {

    static ApplicationFolderQuery create() {
        return new UdbApplicationFolderQuery();
    }

    ApplicationFolderQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ApplicationFolderQuery parseFullTextFilter(String query, String... fieldNames);

	ApplicationFolderQuery metaCreationDate(NumericFilter filter);

	ApplicationFolderQuery orMetaCreationDate(NumericFilter filter);

	ApplicationFolderQuery metaCreatedBy(NumericFilter filter);

	ApplicationFolderQuery orMetaCreatedBy(NumericFilter filter);

	ApplicationFolderQuery metaModificationDate(NumericFilter filter);

	ApplicationFolderQuery orMetaModificationDate(NumericFilter filter);

	ApplicationFolderQuery metaModifiedBy(NumericFilter filter);

	ApplicationFolderQuery orMetaModifiedBy(NumericFilter filter);

	ApplicationFolderQuery metaDeletionDate(NumericFilter filter);

	ApplicationFolderQuery orMetaDeletionDate(NumericFilter filter);

	ApplicationFolderQuery metaDeletedBy(NumericFilter filter);

	ApplicationFolderQuery orMetaDeletedBy(NumericFilter filter);

	ApplicationFolderQuery metaRestoreDate(NumericFilter filter);

	ApplicationFolderQuery orMetaRestoreDate(NumericFilter filter);

	ApplicationFolderQuery metaRestoredBy(NumericFilter filter);

	ApplicationFolderQuery orMetaRestoredBy(NumericFilter filter);

	ApplicationFolderQuery name(TextFilter filter);

	ApplicationFolderQuery orName(TextFilter filter);

	ApplicationFolderQuery filterApplication(ApplicationQuery query);

	ApplicationFolderQuery application(NumericFilter filter);

	ApplicationFolderQuery orApplication(NumericFilter filter);

	ApplicationFolderQuery applicationFolderType(EnumFilterType filterType, ApplicationFolderType ... enums);

	ApplicationFolderQuery orApplicationFolderType(EnumFilterType filterType, ApplicationFolderType ... enums);

	ApplicationFolderQuery filterParent(ApplicationFolderQuery query);

	ApplicationFolderQuery parent(NumericFilter filter);

	ApplicationFolderQuery orParent(NumericFilter filter);

	ApplicationFolderQuery filterChildren(ApplicationFolderQuery query);

	ApplicationFolderQuery children(MultiReferenceFilterType type, ApplicationFolder ... value);

	ApplicationFolderQuery childrenCount(MultiReferenceFilterType type, int count);

	ApplicationFolderQuery children(MultiReferenceFilter filter);

	ApplicationFolderQuery orChildren(MultiReferenceFilter filter);

	ApplicationFolderQuery filterMessages(MessageQuery query);

	ApplicationFolderQuery messages(MultiReferenceFilterType type, Message ... value);

	ApplicationFolderQuery messagesCount(MultiReferenceFilterType type, int count);

	ApplicationFolderQuery messages(MultiReferenceFilter filter);

	ApplicationFolderQuery orMessages(MultiReferenceFilter filter);


    ApplicationFolderQuery andOr(ApplicationFolderQuery... queries);

    ApplicationFolderQuery customFilter(Function<ApplicationFolder, Boolean> customFilter);

    List<ApplicationFolder> execute();

    List<ApplicationFolder> executeOnDeletedRecords();

    ApplicationFolder executeExpectSingleton();

    BitSet executeToBitSet();

    List<ApplicationFolder> execute(String sortFieldName, boolean ascending, String ... path);

    List<ApplicationFolder> execute(int startIndex, int length, Sorting sorting);

}

