package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ApplicationPrivilege extends Entity<ApplicationPrivilege> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_PRIVILEGE_GROUP = "privilegeGroup";
	final static String FIELD_NAME = "name";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TITLE_KEY = "titleKey";

    static ApplicationPrivilege create() {
        return new UdbApplicationPrivilege();
    }

    static ApplicationPrivilege create(int id) {
        return new UdbApplicationPrivilege(id, true);
    }

    static ApplicationPrivilege getById(int id) {
        return new UdbApplicationPrivilege(id, false);
    }

    static EntityBuilder<ApplicationPrivilege> getBuilder() {
        return new UdbApplicationPrivilege(0, false);
    }

    Instant getMetaCreationDate();

    ApplicationPrivilege setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ApplicationPrivilege setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ApplicationPrivilege setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ApplicationPrivilege setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ApplicationPrivilege setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ApplicationPrivilege setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ApplicationPrivilege setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ApplicationPrivilege setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ApplicationPrivilege setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ApplicationPrivilege setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ApplicationPrivilege setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ApplicationPrivilege setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    ApplicationPrivilege setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    ApplicationPrivilege setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    ApplicationPrivilege setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    ApplicationPrivilege setMetaRestoredBy(int value);

    ApplicationPrivilegeGroup getPrivilegeGroup();

    ApplicationPrivilege setPrivilegeGroup(ApplicationPrivilegeGroup value);

    String getName();

    ApplicationPrivilege setName(String value);

    String getIcon();

    ApplicationPrivilege setIcon(String value);

    String getTitleKey();

    ApplicationPrivilege setTitleKey(String value);


    static List<ApplicationPrivilege> getAll() {
        return UdbApplicationPrivilege.getAll();
    }

    static List<ApplicationPrivilege> getDeletedRecords() {
        return UdbApplicationPrivilege.getDeletedRecords();
    }

    static List<ApplicationPrivilege> sort(List<ApplicationPrivilege> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplicationPrivilege.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbApplicationPrivilege.getCount();
    }

    static ApplicationPrivilegeQuery filter() {
        return new UdbApplicationPrivilegeQuery();
    }
}

