package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ApplicationPrivilegeQuery extends Query<ApplicationPrivilege> {

    static ApplicationPrivilegeQuery create() {
        return new UdbApplicationPrivilegeQuery();
    }

    ApplicationPrivilegeQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ApplicationPrivilegeQuery parseFullTextFilter(String query, String... fieldNames);

	ApplicationPrivilegeQuery metaCreationDate(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaCreationDate(NumericFilter filter);

	ApplicationPrivilegeQuery metaCreatedBy(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaCreatedBy(NumericFilter filter);

	ApplicationPrivilegeQuery metaModificationDate(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaModificationDate(NumericFilter filter);

	ApplicationPrivilegeQuery metaModifiedBy(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaModifiedBy(NumericFilter filter);

	ApplicationPrivilegeQuery metaDeletionDate(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaDeletionDate(NumericFilter filter);

	ApplicationPrivilegeQuery metaDeletedBy(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaDeletedBy(NumericFilter filter);

	ApplicationPrivilegeQuery metaRestoreDate(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaRestoreDate(NumericFilter filter);

	ApplicationPrivilegeQuery metaRestoredBy(NumericFilter filter);

	ApplicationPrivilegeQuery orMetaRestoredBy(NumericFilter filter);

	ApplicationPrivilegeQuery filterPrivilegeGroup(ApplicationPrivilegeGroupQuery query);

	ApplicationPrivilegeQuery privilegeGroup(NumericFilter filter);

	ApplicationPrivilegeQuery orPrivilegeGroup(NumericFilter filter);

	ApplicationPrivilegeQuery name(TextFilter filter);

	ApplicationPrivilegeQuery orName(TextFilter filter);

	ApplicationPrivilegeQuery icon(TextFilter filter);

	ApplicationPrivilegeQuery orIcon(TextFilter filter);

	ApplicationPrivilegeQuery titleKey(TextFilter filter);

	ApplicationPrivilegeQuery orTitleKey(TextFilter filter);


    ApplicationPrivilegeQuery andOr(ApplicationPrivilegeQuery... queries);

    ApplicationPrivilegeQuery customFilter(Function<ApplicationPrivilege, Boolean> customFilter);

    List<ApplicationPrivilege> execute();

    List<ApplicationPrivilege> executeOnDeletedRecords();

    ApplicationPrivilege executeExpectSingleton();

    BitSet executeToBitSet();

    List<ApplicationPrivilege> execute(String sortFieldName, boolean ascending, String ... path);

    List<ApplicationPrivilege> execute(int startIndex, int length, Sorting sorting);

}

