package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ApplicationVersionDataQuery extends Query<ApplicationVersionData> {

    static ApplicationVersionDataQuery create() {
        return new UdbApplicationVersionDataQuery();
    }

    ApplicationVersionDataQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ApplicationVersionDataQuery parseFullTextFilter(String query, String... fieldNames);

	ApplicationVersionDataQuery metaCreationDate(NumericFilter filter);

	ApplicationVersionDataQuery orMetaCreationDate(NumericFilter filter);

	ApplicationVersionDataQuery metaCreatedBy(NumericFilter filter);

	ApplicationVersionDataQuery orMetaCreatedBy(NumericFilter filter);

	ApplicationVersionDataQuery metaModificationDate(NumericFilter filter);

	ApplicationVersionDataQuery orMetaModificationDate(NumericFilter filter);

	ApplicationVersionDataQuery metaModifiedBy(NumericFilter filter);

	ApplicationVersionDataQuery orMetaModifiedBy(NumericFilter filter);

	ApplicationVersionDataQuery metaDeletionDate(NumericFilter filter);

	ApplicationVersionDataQuery orMetaDeletionDate(NumericFilter filter);

	ApplicationVersionDataQuery metaDeletedBy(NumericFilter filter);

	ApplicationVersionDataQuery orMetaDeletedBy(NumericFilter filter);

	ApplicationVersionDataQuery metaRestoreDate(NumericFilter filter);

	ApplicationVersionDataQuery orMetaRestoreDate(NumericFilter filter);

	ApplicationVersionDataQuery metaRestoredBy(NumericFilter filter);

	ApplicationVersionDataQuery orMetaRestoredBy(NumericFilter filter);

	ApplicationVersionDataQuery data(TextFilter filter);

	ApplicationVersionDataQuery orData(TextFilter filter);

	ApplicationVersionDataQuery dataRows(NumericFilter filter);

	ApplicationVersionDataQuery orDataRows(NumericFilter filter);

	ApplicationVersionDataQuery dataAdded(TextFilter filter);

	ApplicationVersionDataQuery orDataAdded(TextFilter filter);

	ApplicationVersionDataQuery dataAddedRows(NumericFilter filter);

	ApplicationVersionDataQuery orDataAddedRows(NumericFilter filter);

	ApplicationVersionDataQuery dataRemoved(TextFilter filter);

	ApplicationVersionDataQuery orDataRemoved(TextFilter filter);

	ApplicationVersionDataQuery dataRemovedRows(NumericFilter filter);

	ApplicationVersionDataQuery orDataRemovedRows(NumericFilter filter);


    ApplicationVersionDataQuery andOr(ApplicationVersionDataQuery... queries);

    ApplicationVersionDataQuery customFilter(Function<ApplicationVersionData, Boolean> customFilter);

    List<ApplicationVersionData> execute();

    List<ApplicationVersionData> executeOnDeletedRecords();

    ApplicationVersionData executeExpectSingleton();

    BitSet executeToBitSet();

    List<ApplicationVersionData> execute(String sortFieldName, boolean ascending, String ... path);

    List<ApplicationVersionData> execute(int startIndex, int length, Sorting sorting);

}

