package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ChatMessage extends Entity<ChatMessage> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_CHAT_CHANNEL = "chatChannel";
	final static String FIELD_AUTHOR = "author";
	final static String FIELD_MESSAGE = "message";

    static ChatMessage create() {
        return new UdbChatMessage();
    }

    static ChatMessage create(int id) {
        return new UdbChatMessage(id, true);
    }

    static ChatMessage getById(int id) {
        return new UdbChatMessage(id, false);
    }

    static EntityBuilder<ChatMessage> getBuilder() {
        return new UdbChatMessage(0, false);
    }

    Instant getMetaCreationDate();

    ChatMessage setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ChatMessage setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ChatMessage setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ChatMessage setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ChatMessage setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ChatMessage setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ChatMessage setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ChatMessage setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ChatMessage setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ChatMessage setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ChatMessage setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ChatMessage setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    ChatMessage setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    ChatMessage setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    ChatMessage setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    ChatMessage setMetaRestoredBy(int value);

    ChatChannel getChatChannel();

    ChatMessage setChatChannel(ChatChannel value);

    User getAuthor();

    ChatMessage setAuthor(User value);

    String getMessage();

    ChatMessage setMessage(String value);


    static List<ChatMessage> getAll() {
        return UdbChatMessage.getAll();
    }

    static List<ChatMessage> getDeletedRecords() {
        return UdbChatMessage.getDeletedRecords();
    }

    static List<ChatMessage> sort(List<ChatMessage> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbChatMessage.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbChatMessage.getCount();
    }

    static ChatMessageQuery filter() {
        return new UdbChatMessageQuery();
    }
}

