package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ChatMessageQuery extends Query<ChatMessage> {

    static ChatMessageQuery create() {
        return new UdbChatMessageQuery();
    }

    ChatMessageQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ChatMessageQuery parseFullTextFilter(String query, String... fieldNames);

	ChatMessageQuery metaCreationDate(NumericFilter filter);

	ChatMessageQuery orMetaCreationDate(NumericFilter filter);

	ChatMessageQuery metaCreatedBy(NumericFilter filter);

	ChatMessageQuery orMetaCreatedBy(NumericFilter filter);

	ChatMessageQuery metaModificationDate(NumericFilter filter);

	ChatMessageQuery orMetaModificationDate(NumericFilter filter);

	ChatMessageQuery metaModifiedBy(NumericFilter filter);

	ChatMessageQuery orMetaModifiedBy(NumericFilter filter);

	ChatMessageQuery metaDeletionDate(NumericFilter filter);

	ChatMessageQuery orMetaDeletionDate(NumericFilter filter);

	ChatMessageQuery metaDeletedBy(NumericFilter filter);

	ChatMessageQuery orMetaDeletedBy(NumericFilter filter);

	ChatMessageQuery metaRestoreDate(NumericFilter filter);

	ChatMessageQuery orMetaRestoreDate(NumericFilter filter);

	ChatMessageQuery metaRestoredBy(NumericFilter filter);

	ChatMessageQuery orMetaRestoredBy(NumericFilter filter);

	ChatMessageQuery filterChatChannel(ChatChannelQuery query);

	ChatMessageQuery chatChannel(NumericFilter filter);

	ChatMessageQuery orChatChannel(NumericFilter filter);

	ChatMessageQuery filterAuthor(UserQuery query);

	ChatMessageQuery author(NumericFilter filter);

	ChatMessageQuery orAuthor(NumericFilter filter);

	ChatMessageQuery message(TextFilter filter);

	ChatMessageQuery orMessage(TextFilter filter);


    ChatMessageQuery andOr(ChatMessageQuery... queries);

    ChatMessageQuery customFilter(Function<ChatMessage, Boolean> customFilter);

    List<ChatMessage> execute();

    List<ChatMessage> executeOnDeletedRecords();

    ChatMessage executeExpectSingleton();

    BitSet executeToBitSet();

    List<ChatMessage> execute(String sortFieldName, boolean ascending, String ... path);

    List<ChatMessage> execute(int startIndex, int length, Sorting sorting);

}

