package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Country extends Entity<Country> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_ISO_CODE = "isoCode";
	final static String FIELD_ICON = "icon";
	final static String FIELD_ENGLISH_DISPLAY_NAME = "englishDisplayName";
	final static String FIELD_LOCALIZATION_KEY = "localizationKey";
	final static String FIELD_ADDRESS_FORMAT = "addressFormat";
	final static String FIELD_MAIN_LANGUAGE = "mainLanguage";
	final static String FIELD_OTHER_LANGUAGES = "otherLanguages";
	final static String FIELD_CURRENCY = "currency";
	final static String FIELD_OTHER_CURRENCIES = "otherCurrencies";

    static Country create() {
        return new UdbCountry();
    }

    static Country create(int id) {
        return new UdbCountry(id, true);
    }

    static Country getById(int id) {
        return new UdbCountry(id, false);
    }

    static EntityBuilder<Country> getBuilder() {
        return new UdbCountry(0, false);
    }

    Instant getMetaCreationDate();

    Country setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Country setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Country setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Country setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Country setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Country setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Country setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Country setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Country setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Country setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Country setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Country setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    Country setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    Country setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    Country setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    Country setMetaRestoredBy(int value);

    String getIsoCode();

    Country setIsoCode(String value);

    String getIcon();

    Country setIcon(String value);

    String getEnglishDisplayName();

    Country setEnglishDisplayName(String value);

    LocalizationKey getLocalizationKey();

    Country setLocalizationKey(LocalizationKey value);

    String getAddressFormat();

    Country setAddressFormat(String value);

    Language getMainLanguage();

    Country setMainLanguage(Language value);

    List<Language> getOtherLanguages();

    Country setOtherLanguages(List<Language> value);

    int getOtherLanguagesCount();

    Country setOtherLanguages(Language ... value);

    BitSet getOtherLanguagesAsBitSet();

    Country addOtherLanguages(List<Language> value);

    Country addOtherLanguages(Language ... value);

    Country removeOtherLanguages(List<Language> value);

    Country removeOtherLanguages(Language ... value);

    Country removeAllOtherLanguages();

    Currency getCurrency();

    Country setCurrency(Currency value);

    List<Currency> getOtherCurrencies();

    Country setOtherCurrencies(List<Currency> value);

    int getOtherCurrenciesCount();

    Country setOtherCurrencies(Currency ... value);

    BitSet getOtherCurrenciesAsBitSet();

    Country addOtherCurrencies(List<Currency> value);

    Country addOtherCurrencies(Currency ... value);

    Country removeOtherCurrencies(List<Currency> value);

    Country removeOtherCurrencies(Currency ... value);

    Country removeAllOtherCurrencies();


    static List<Country> getAll() {
        return UdbCountry.getAll();
    }

    static List<Country> getDeletedRecords() {
        return UdbCountry.getDeletedRecords();
    }

    static List<Country> sort(List<Country> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbCountry.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbCountry.getCount();
    }

    static CountryQuery filter() {
        return new UdbCountryQuery();
    }
}

