package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Currency extends Entity<Currency> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";

    static Currency create() {
        return new UdbCurrency();
    }

    static Currency create(int id) {
        return new UdbCurrency(id, true);
    }

    static Currency getById(int id) {
        return new UdbCurrency(id, false);
    }

    static EntityBuilder<Currency> getBuilder() {
        return new UdbCurrency(0, false);
    }

    Instant getMetaCreationDate();

    Currency setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Currency setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Currency setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Currency setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Currency setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Currency setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Currency setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Currency setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Currency setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Currency setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Currency setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Currency setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    Currency setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    Currency setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    Currency setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    Currency setMetaRestoredBy(int value);


    static List<Currency> getAll() {
        return UdbCurrency.getAll();
    }

    static List<Currency> getDeletedRecords() {
        return UdbCurrency.getDeletedRecords();
    }

    static List<Currency> sort(List<Currency> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbCurrency.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbCurrency.getCount();
    }

    static CurrencyQuery filter() {
        return new UdbCurrencyQuery();
    }
}

