package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface GroupMembershipDefinitionQuery extends Query<GroupMembershipDefinition> {

    static GroupMembershipDefinitionQuery create() {
        return new UdbGroupMembershipDefinitionQuery();
    }

    GroupMembershipDefinitionQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    GroupMembershipDefinitionQuery parseFullTextFilter(String query, String... fieldNames);

	GroupMembershipDefinitionQuery metaCreationDate(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaCreationDate(NumericFilter filter);

	GroupMembershipDefinitionQuery metaCreatedBy(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaCreatedBy(NumericFilter filter);

	GroupMembershipDefinitionQuery metaModificationDate(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaModificationDate(NumericFilter filter);

	GroupMembershipDefinitionQuery metaModifiedBy(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaModifiedBy(NumericFilter filter);

	GroupMembershipDefinitionQuery metaDeletionDate(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaDeletionDate(NumericFilter filter);

	GroupMembershipDefinitionQuery metaDeletedBy(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaDeletedBy(NumericFilter filter);

	GroupMembershipDefinitionQuery metaRestoreDate(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaRestoreDate(NumericFilter filter);

	GroupMembershipDefinitionQuery metaRestoredBy(NumericFilter filter);

	GroupMembershipDefinitionQuery orMetaRestoredBy(NumericFilter filter);

	GroupMembershipDefinitionQuery groupMemberType(EnumFilterType filterType, GroupMemberType ... enums);

	GroupMembershipDefinitionQuery orGroupMemberType(EnumFilterType filterType, GroupMemberType ... enums);

	GroupMembershipDefinitionQuery filterUser(UserQuery query);

	GroupMembershipDefinitionQuery user(NumericFilter filter);

	GroupMembershipDefinitionQuery orUser(NumericFilter filter);

	GroupMembershipDefinitionQuery filterGroup(GroupQuery query);

	GroupMembershipDefinitionQuery group(NumericFilter filter);

	GroupMembershipDefinitionQuery orGroup(NumericFilter filter);

	GroupMembershipDefinitionQuery filterRole(RoleQuery query);

	GroupMembershipDefinitionQuery role(NumericFilter filter);

	GroupMembershipDefinitionQuery orRole(NumericFilter filter);

	GroupMembershipDefinitionQuery filterOrganizationUnit(OrganizationUnitQuery query);

	GroupMembershipDefinitionQuery organizationUnit(NumericFilter filter);

	GroupMembershipDefinitionQuery orOrganizationUnit(NumericFilter filter);

	GroupMembershipDefinitionQuery filterOrganizationUnitTypesFilter(OrganizationUnitTypeQuery query);

	GroupMembershipDefinitionQuery organizationUnitTypesFilter(MultiReferenceFilterType type, OrganizationUnitType ... value);

	GroupMembershipDefinitionQuery organizationUnitTypesFilterCount(MultiReferenceFilterType type, int count);

	GroupMembershipDefinitionQuery organizationUnitTypesFilter(MultiReferenceFilter filter);

	GroupMembershipDefinitionQuery orOrganizationUnitTypesFilter(MultiReferenceFilter filter);


    GroupMembershipDefinitionQuery andOr(GroupMembershipDefinitionQuery... queries);

    GroupMembershipDefinitionQuery customFilter(Function<GroupMembershipDefinition, Boolean> customFilter);

    List<GroupMembershipDefinition> execute();

    List<GroupMembershipDefinition> executeOnDeletedRecords();

    GroupMembershipDefinition executeExpectSingleton();

    BitSet executeToBitSet();

    List<GroupMembershipDefinition> execute(String sortFieldName, boolean ascending, String ... path);

    List<GroupMembershipDefinition> execute(int startIndex, int length, Sorting sorting);

}

