package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface GroupQuery extends Query<Group> {

    static GroupQuery create() {
        return new UdbGroupQuery();
    }

    GroupQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    GroupQuery parseFullTextFilter(String query, String... fieldNames);

	GroupQuery metaCreationDate(NumericFilter filter);

	GroupQuery orMetaCreationDate(NumericFilter filter);

	GroupQuery metaCreatedBy(NumericFilter filter);

	GroupQuery orMetaCreatedBy(NumericFilter filter);

	GroupQuery metaModificationDate(NumericFilter filter);

	GroupQuery orMetaModificationDate(NumericFilter filter);

	GroupQuery metaModifiedBy(NumericFilter filter);

	GroupQuery orMetaModifiedBy(NumericFilter filter);

	GroupQuery metaDeletionDate(NumericFilter filter);

	GroupQuery orMetaDeletionDate(NumericFilter filter);

	GroupQuery metaDeletedBy(NumericFilter filter);

	GroupQuery orMetaDeletedBy(NumericFilter filter);

	GroupQuery metaRestoreDate(NumericFilter filter);

	GroupQuery orMetaRestoreDate(NumericFilter filter);

	GroupQuery metaRestoredBy(NumericFilter filter);

	GroupQuery orMetaRestoredBy(NumericFilter filter);

	GroupQuery groupType(EnumFilterType filterType, GroupType ... enums);

	GroupQuery orGroupType(EnumFilterType filterType, GroupType ... enums);

	GroupQuery name(TextFilter filter);

	GroupQuery orName(TextFilter filter);

	GroupQuery description(TextFilter filter);

	GroupQuery orDescription(TextFilter filter);

	GroupQuery language(TextFilter filter);

	GroupQuery orLanguage(TextFilter filter);

	GroupQuery filterOrganizationField(OrganizationFieldQuery query);

	GroupQuery organizationField(NumericFilter filter);

	GroupQuery orOrganizationField(NumericFilter filter);

	GroupQuery filterOrganizationUnit(OrganizationUnitQuery query);

	GroupQuery organizationUnit(NumericFilter filter);

	GroupQuery orOrganizationUnit(NumericFilter filter);

	GroupQuery filterOwner(UserQuery query);

	GroupQuery owner(NumericFilter filter);

	GroupQuery orOwner(NumericFilter filter);

	GroupQuery filterModerators(UserQuery query);

	GroupQuery moderators(MultiReferenceFilterType type, User ... value);

	GroupQuery moderatorsCount(MultiReferenceFilterType type, int count);

	GroupQuery moderators(MultiReferenceFilter filter);

	GroupQuery orModerators(MultiReferenceFilter filter);

	GroupQuery filterMentors(UserQuery query);

	GroupQuery mentors(MultiReferenceFilterType type, User ... value);

	GroupQuery mentorsCount(MultiReferenceFilterType type, int count);

	GroupQuery mentors(MultiReferenceFilter filter);

	GroupQuery orMentors(MultiReferenceFilter filter);

	GroupQuery valid(BooleanFilter filter);

	GroupQuery orValid(BooleanFilter filter);

	GroupQuery filterMembershipDefinitions(GroupMembershipDefinitionQuery query);

	GroupQuery membershipDefinitions(MultiReferenceFilterType type, GroupMembershipDefinition ... value);

	GroupQuery membershipDefinitionsCount(MultiReferenceFilterType type, int count);

	GroupQuery membershipDefinitions(MultiReferenceFilter filter);

	GroupQuery orMembershipDefinitions(MultiReferenceFilter filter);

	GroupQuery filterRegistrationAllowedForDefinitions(GroupMembershipDefinitionQuery query);

	GroupQuery registrationAllowedForDefinitions(MultiReferenceFilterType type, GroupMembershipDefinition ... value);

	GroupQuery registrationAllowedForDefinitionsCount(MultiReferenceFilterType type, int count);

	GroupQuery registrationAllowedForDefinitions(MultiReferenceFilter filter);

	GroupQuery orRegistrationAllowedForDefinitions(MultiReferenceFilter filter);

	GroupQuery filterUserMemberships(UserGroupMembershipQuery query);

	GroupQuery userMemberships(MultiReferenceFilterType type, UserGroupMembership ... value);

	GroupQuery userMembershipsCount(MultiReferenceFilterType type, int count);

	GroupQuery userMemberships(MultiReferenceFilter filter);

	GroupQuery orUserMemberships(MultiReferenceFilter filter);

	GroupQuery lastMessageDate(NumericFilter filter);

	GroupQuery orLastMessageDate(NumericFilter filter);

	GroupQuery filterGroupFolders(GroupFolderQuery query);

	GroupQuery groupFolders(MultiReferenceFilterType type, GroupFolder ... value);

	GroupQuery groupFoldersCount(MultiReferenceFilterType type, int count);

	GroupQuery groupFolders(MultiReferenceFilter filter);

	GroupQuery orGroupFolders(MultiReferenceFilter filter);


    GroupQuery andOr(GroupQuery... queries);

    GroupQuery customFilter(Function<Group, Boolean> customFilter);

    List<Group> execute();

    List<Group> executeOnDeletedRecords();

    Group executeExpectSingleton();

    BitSet executeToBitSet();

    List<Group> execute(String sortFieldName, boolean ascending, String ... path);

    List<Group> execute(int startIndex, int length, Sorting sorting);

}

