package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Language extends Entity<Language> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_ISO_CODE = "isoCode";
	final static String FIELD_ICON = "icon";
	final static String FIELD_ENGLISH_DISPLAY_NAME = "englishDisplayName";
	final static String FIELD_NON_LATIN_SCRIPT = "nonLatinScript";
	final static String FIELD_RIGHT_TO_LEFT_LANGUAGE = "rightToLeftLanguage";
	final static String FIELD_LOCALIZATION_KEY = "localizationKey";

    static Language create() {
        return new UdbLanguage();
    }

    static Language create(int id) {
        return new UdbLanguage(id, true);
    }

    static Language getById(int id) {
        return new UdbLanguage(id, false);
    }

    static EntityBuilder<Language> getBuilder() {
        return new UdbLanguage(0, false);
    }

    Instant getMetaCreationDate();

    Language setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Language setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Language setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Language setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Language setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Language setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Language setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Language setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Language setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Language setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Language setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Language setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    Language setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    Language setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    Language setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    Language setMetaRestoredBy(int value);

    String getIsoCode();

    Language setIsoCode(String value);

    String getIcon();

    Language setIcon(String value);

    String getEnglishDisplayName();

    Language setEnglishDisplayName(String value);

    boolean getNonLatinScript();

    Language setNonLatinScript(boolean value);

    boolean isNonLatinScript();

    boolean getRightToLeftLanguage();

    Language setRightToLeftLanguage(boolean value);

    boolean isRightToLeftLanguage();

    LocalizationKey getLocalizationKey();

    Language setLocalizationKey(LocalizationKey value);


    static List<Language> getAll() {
        return UdbLanguage.getAll();
    }

    static List<Language> getDeletedRecords() {
        return UdbLanguage.getDeletedRecords();
    }

    static List<Language> sort(List<Language> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbLanguage.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbLanguage.getCount();
    }

    static LanguageQuery filter() {
        return new UdbLanguageQuery();
    }
}

