package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface LanguageQuery extends Query<Language> {

    static LanguageQuery create() {
        return new UdbLanguageQuery();
    }

    LanguageQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    LanguageQuery parseFullTextFilter(String query, String... fieldNames);

	LanguageQuery metaCreationDate(NumericFilter filter);

	LanguageQuery orMetaCreationDate(NumericFilter filter);

	LanguageQuery metaCreatedBy(NumericFilter filter);

	LanguageQuery orMetaCreatedBy(NumericFilter filter);

	LanguageQuery metaModificationDate(NumericFilter filter);

	LanguageQuery orMetaModificationDate(NumericFilter filter);

	LanguageQuery metaModifiedBy(NumericFilter filter);

	LanguageQuery orMetaModifiedBy(NumericFilter filter);

	LanguageQuery metaDeletionDate(NumericFilter filter);

	LanguageQuery orMetaDeletionDate(NumericFilter filter);

	LanguageQuery metaDeletedBy(NumericFilter filter);

	LanguageQuery orMetaDeletedBy(NumericFilter filter);

	LanguageQuery metaRestoreDate(NumericFilter filter);

	LanguageQuery orMetaRestoreDate(NumericFilter filter);

	LanguageQuery metaRestoredBy(NumericFilter filter);

	LanguageQuery orMetaRestoredBy(NumericFilter filter);

	LanguageQuery isoCode(TextFilter filter);

	LanguageQuery orIsoCode(TextFilter filter);

	LanguageQuery icon(TextFilter filter);

	LanguageQuery orIcon(TextFilter filter);

	LanguageQuery englishDisplayName(TextFilter filter);

	LanguageQuery orEnglishDisplayName(TextFilter filter);

	LanguageQuery nonLatinScript(BooleanFilter filter);

	LanguageQuery orNonLatinScript(BooleanFilter filter);

	LanguageQuery rightToLeftLanguage(BooleanFilter filter);

	LanguageQuery orRightToLeftLanguage(BooleanFilter filter);

	LanguageQuery filterLocalizationKey(LocalizationKeyQuery query);

	LanguageQuery localizationKey(NumericFilter filter);

	LanguageQuery orLocalizationKey(NumericFilter filter);


    LanguageQuery andOr(LanguageQuery... queries);

    LanguageQuery customFilter(Function<Language, Boolean> customFilter);

    List<Language> execute();

    List<Language> executeOnDeletedRecords();

    Language executeExpectSingleton();

    BitSet executeToBitSet();

    List<Language> execute(String sortFieldName, boolean ascending, String ... path);

    List<Language> execute(int startIndex, int length, Sorting sorting);

}

