package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface LocalizationTopicQuery extends Query<LocalizationTopic> {

    static LocalizationTopicQuery create() {
        return new UdbLocalizationTopicQuery();
    }

    LocalizationTopicQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    LocalizationTopicQuery parseFullTextFilter(String query, String... fieldNames);

	LocalizationTopicQuery metaCreationDate(NumericFilter filter);

	LocalizationTopicQuery orMetaCreationDate(NumericFilter filter);

	LocalizationTopicQuery metaCreatedBy(NumericFilter filter);

	LocalizationTopicQuery orMetaCreatedBy(NumericFilter filter);

	LocalizationTopicQuery metaModificationDate(NumericFilter filter);

	LocalizationTopicQuery orMetaModificationDate(NumericFilter filter);

	LocalizationTopicQuery metaModifiedBy(NumericFilter filter);

	LocalizationTopicQuery orMetaModifiedBy(NumericFilter filter);

	LocalizationTopicQuery metaDeletionDate(NumericFilter filter);

	LocalizationTopicQuery orMetaDeletionDate(NumericFilter filter);

	LocalizationTopicQuery metaDeletedBy(NumericFilter filter);

	LocalizationTopicQuery orMetaDeletedBy(NumericFilter filter);

	LocalizationTopicQuery metaRestoreDate(NumericFilter filter);

	LocalizationTopicQuery orMetaRestoreDate(NumericFilter filter);

	LocalizationTopicQuery metaRestoredBy(NumericFilter filter);

	LocalizationTopicQuery orMetaRestoredBy(NumericFilter filter);

	LocalizationTopicQuery filterKeys(LocalizationKeyQuery query);

	LocalizationTopicQuery keys(MultiReferenceFilterType type, LocalizationKey ... value);

	LocalizationTopicQuery keysCount(MultiReferenceFilterType type, int count);

	LocalizationTopicQuery keys(MultiReferenceFilter filter);

	LocalizationTopicQuery orKeys(MultiReferenceFilter filter);

	LocalizationTopicQuery filterApplication(ApplicationQuery query);

	LocalizationTopicQuery application(NumericFilter filter);

	LocalizationTopicQuery orApplication(NumericFilter filter);

	LocalizationTopicQuery icon(TextFilter filter);

	LocalizationTopicQuery orIcon(TextFilter filter);

	LocalizationTopicQuery title(TextFilter filter);

	LocalizationTopicQuery orTitle(TextFilter filter);

	LocalizationTopicQuery screenshot(FileFilter filter);

	LocalizationTopicQuery orScreenshot(FileFilter filter);


    LocalizationTopicQuery andOr(LocalizationTopicQuery... queries);

    LocalizationTopicQuery customFilter(Function<LocalizationTopic, Boolean> customFilter);

    List<LocalizationTopic> execute();

    List<LocalizationTopic> executeOnDeletedRecords();

    LocalizationTopic executeExpectSingleton();

    BitSet executeToBitSet();

    List<LocalizationTopic> execute(String sortFieldName, boolean ascending, String ... path);

    List<LocalizationTopic> execute(int startIndex, int length, Sorting sorting);

}

