package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface LocalizationValueQuery extends Query<LocalizationValue> {

    static LocalizationValueQuery create() {
        return new UdbLocalizationValueQuery();
    }

    LocalizationValueQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    LocalizationValueQuery parseFullTextFilter(String query, String... fieldNames);

	LocalizationValueQuery metaCreationDate(NumericFilter filter);

	LocalizationValueQuery orMetaCreationDate(NumericFilter filter);

	LocalizationValueQuery metaCreatedBy(NumericFilter filter);

	LocalizationValueQuery orMetaCreatedBy(NumericFilter filter);

	LocalizationValueQuery metaModificationDate(NumericFilter filter);

	LocalizationValueQuery orMetaModificationDate(NumericFilter filter);

	LocalizationValueQuery metaModifiedBy(NumericFilter filter);

	LocalizationValueQuery orMetaModifiedBy(NumericFilter filter);

	LocalizationValueQuery metaDeletionDate(NumericFilter filter);

	LocalizationValueQuery orMetaDeletionDate(NumericFilter filter);

	LocalizationValueQuery metaDeletedBy(NumericFilter filter);

	LocalizationValueQuery orMetaDeletedBy(NumericFilter filter);

	LocalizationValueQuery metaRestoreDate(NumericFilter filter);

	LocalizationValueQuery orMetaRestoreDate(NumericFilter filter);

	LocalizationValueQuery metaRestoredBy(NumericFilter filter);

	LocalizationValueQuery orMetaRestoredBy(NumericFilter filter);

	LocalizationValueQuery filterLocalizationKey(LocalizationKeyQuery query);

	LocalizationValueQuery localizationKey(NumericFilter filter);

	LocalizationValueQuery orLocalizationKey(NumericFilter filter);

	LocalizationValueQuery language(TextFilter filter);

	LocalizationValueQuery orLanguage(TextFilter filter);

	LocalizationValueQuery original(TextFilter filter);

	LocalizationValueQuery orOriginal(TextFilter filter);

	LocalizationValueQuery machineTranslation(TextFilter filter);

	LocalizationValueQuery orMachineTranslation(TextFilter filter);

	LocalizationValueQuery translation(TextFilter filter);

	LocalizationValueQuery orTranslation(TextFilter filter);

	LocalizationValueQuery adminLocalOverride(TextFilter filter);

	LocalizationValueQuery orAdminLocalOverride(TextFilter filter);

	LocalizationValueQuery adminKeyOverride(TextFilter filter);

	LocalizationValueQuery orAdminKeyOverride(TextFilter filter);

	LocalizationValueQuery currentDisplayValue(TextFilter filter);

	LocalizationValueQuery orCurrentDisplayValue(TextFilter filter);

	LocalizationValueQuery notes(TextFilter filter);

	LocalizationValueQuery orNotes(TextFilter filter);

	LocalizationValueQuery machineTranslationState(EnumFilterType filterType, MachineTranslationState ... enums);

	LocalizationValueQuery orMachineTranslationState(EnumFilterType filterType, MachineTranslationState ... enums);

	LocalizationValueQuery translationState(EnumFilterType filterType, TranslationState ... enums);

	LocalizationValueQuery orTranslationState(EnumFilterType filterType, TranslationState ... enums);

	LocalizationValueQuery translationVerificationState(EnumFilterType filterType, TranslationVerificationState ... enums);

	LocalizationValueQuery orTranslationVerificationState(EnumFilterType filterType, TranslationVerificationState ... enums);


    LocalizationValueQuery andOr(LocalizationValueQuery... queries);

    LocalizationValueQuery customFilter(Function<LocalizationValue, Boolean> customFilter);

    List<LocalizationValue> execute();

    List<LocalizationValue> executeOnDeletedRecords();

    LocalizationValue executeExpectSingleton();

    BitSet executeToBitSet();

    List<LocalizationValue> execute(String sortFieldName, boolean ascending, String ... path);

    List<LocalizationValue> execute(int startIndex, int length, Sorting sorting);

}

