package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ManagedApplicationPerspective extends Entity<ManagedApplicationPerspective> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_MANAGED_APPLICATION = "managedApplication";
	final static String FIELD_APPLICATION_PERSPECTIVE = "applicationPerspective";
	final static String FIELD_ICON_OVERRIDE = "iconOverride";
	final static String FIELD_TITLE_KEY_OVERRIDE = "titleKeyOverride";
	final static String FIELD_DESCRIPTION_KEY_OVERRIDE = "descriptionKeyOverride";
	final static String FIELD_TOOLBAR_PERSPECTIVE_MENU = "toolbarPerspectiveMenu";
	final static String FIELD_LISTING_POSITION = "listingPosition";

    static ManagedApplicationPerspective create() {
        return new UdbManagedApplicationPerspective();
    }

    static ManagedApplicationPerspective create(int id) {
        return new UdbManagedApplicationPerspective(id, true);
    }

    static ManagedApplicationPerspective getById(int id) {
        return new UdbManagedApplicationPerspective(id, false);
    }

    static EntityBuilder<ManagedApplicationPerspective> getBuilder() {
        return new UdbManagedApplicationPerspective(0, false);
    }

    Instant getMetaCreationDate();

    ManagedApplicationPerspective setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ManagedApplicationPerspective setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ManagedApplicationPerspective setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ManagedApplicationPerspective setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ManagedApplicationPerspective setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ManagedApplicationPerspective setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ManagedApplicationPerspective setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ManagedApplicationPerspective setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ManagedApplicationPerspective setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ManagedApplicationPerspective setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ManagedApplicationPerspective setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ManagedApplicationPerspective setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    ManagedApplicationPerspective setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    ManagedApplicationPerspective setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    ManagedApplicationPerspective setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    ManagedApplicationPerspective setMetaRestoredBy(int value);

    ManagedApplication getManagedApplication();

    ManagedApplicationPerspective setManagedApplication(ManagedApplication value);

    ApplicationPerspective getApplicationPerspective();

    ManagedApplicationPerspective setApplicationPerspective(ApplicationPerspective value);

    String getIconOverride();

    ManagedApplicationPerspective setIconOverride(String value);

    String getTitleKeyOverride();

    ManagedApplicationPerspective setTitleKeyOverride(String value);

    String getDescriptionKeyOverride();

    ManagedApplicationPerspective setDescriptionKeyOverride(String value);

    boolean getToolbarPerspectiveMenu();

    ManagedApplicationPerspective setToolbarPerspectiveMenu(boolean value);

    boolean isToolbarPerspectiveMenu();

    int getListingPosition();

    ManagedApplicationPerspective setListingPosition(int value);


    static List<ManagedApplicationPerspective> getAll() {
        return UdbManagedApplicationPerspective.getAll();
    }

    static List<ManagedApplicationPerspective> getDeletedRecords() {
        return UdbManagedApplicationPerspective.getDeletedRecords();
    }

    static List<ManagedApplicationPerspective> sort(List<ManagedApplicationPerspective> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbManagedApplicationPerspective.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbManagedApplicationPerspective.getCount();
    }

    static ManagedApplicationPerspectiveQuery filter() {
        return new UdbManagedApplicationPerspectiveQuery();
    }
}

