package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ManagedApplicationPerspectiveQuery extends Query<ManagedApplicationPerspective> {

    static ManagedApplicationPerspectiveQuery create() {
        return new UdbManagedApplicationPerspectiveQuery();
    }

    ManagedApplicationPerspectiveQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ManagedApplicationPerspectiveQuery parseFullTextFilter(String query, String... fieldNames);

	ManagedApplicationPerspectiveQuery metaCreationDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaCreationDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery metaCreatedBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaCreatedBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery metaModificationDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaModificationDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery metaModifiedBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaModifiedBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery metaDeletionDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaDeletionDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery metaDeletedBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaDeletedBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery metaRestoreDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaRestoreDate(NumericFilter filter);

	ManagedApplicationPerspectiveQuery metaRestoredBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orMetaRestoredBy(NumericFilter filter);

	ManagedApplicationPerspectiveQuery filterManagedApplication(ManagedApplicationQuery query);

	ManagedApplicationPerspectiveQuery managedApplication(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orManagedApplication(NumericFilter filter);

	ManagedApplicationPerspectiveQuery filterApplicationPerspective(ApplicationPerspectiveQuery query);

	ManagedApplicationPerspectiveQuery applicationPerspective(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orApplicationPerspective(NumericFilter filter);

	ManagedApplicationPerspectiveQuery iconOverride(TextFilter filter);

	ManagedApplicationPerspectiveQuery orIconOverride(TextFilter filter);

	ManagedApplicationPerspectiveQuery titleKeyOverride(TextFilter filter);

	ManagedApplicationPerspectiveQuery orTitleKeyOverride(TextFilter filter);

	ManagedApplicationPerspectiveQuery descriptionKeyOverride(TextFilter filter);

	ManagedApplicationPerspectiveQuery orDescriptionKeyOverride(TextFilter filter);

	ManagedApplicationPerspectiveQuery toolbarPerspectiveMenu(BooleanFilter filter);

	ManagedApplicationPerspectiveQuery orToolbarPerspectiveMenu(BooleanFilter filter);

	ManagedApplicationPerspectiveQuery listingPosition(NumericFilter filter);

	ManagedApplicationPerspectiveQuery orListingPosition(NumericFilter filter);


    ManagedApplicationPerspectiveQuery andOr(ManagedApplicationPerspectiveQuery... queries);

    ManagedApplicationPerspectiveQuery customFilter(Function<ManagedApplicationPerspective, Boolean> customFilter);

    List<ManagedApplicationPerspective> execute();

    List<ManagedApplicationPerspective> executeOnDeletedRecords();

    ManagedApplicationPerspective executeExpectSingleton();

    BitSet executeToBitSet();

    List<ManagedApplicationPerspective> execute(String sortFieldName, boolean ascending, String ... path);

    List<ManagedApplicationPerspective> execute(int startIndex, int length, Sorting sorting);

}

