package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ManagedApplicationQuery extends Query<ManagedApplication> {

    static ManagedApplicationQuery create() {
        return new UdbManagedApplicationQuery();
    }

    ManagedApplicationQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ManagedApplicationQuery parseFullTextFilter(String query, String... fieldNames);

	ManagedApplicationQuery metaCreationDate(NumericFilter filter);

	ManagedApplicationQuery orMetaCreationDate(NumericFilter filter);

	ManagedApplicationQuery metaCreatedBy(NumericFilter filter);

	ManagedApplicationQuery orMetaCreatedBy(NumericFilter filter);

	ManagedApplicationQuery metaModificationDate(NumericFilter filter);

	ManagedApplicationQuery orMetaModificationDate(NumericFilter filter);

	ManagedApplicationQuery metaModifiedBy(NumericFilter filter);

	ManagedApplicationQuery orMetaModifiedBy(NumericFilter filter);

	ManagedApplicationQuery metaDeletionDate(NumericFilter filter);

	ManagedApplicationQuery orMetaDeletionDate(NumericFilter filter);

	ManagedApplicationQuery metaDeletedBy(NumericFilter filter);

	ManagedApplicationQuery orMetaDeletedBy(NumericFilter filter);

	ManagedApplicationQuery metaRestoreDate(NumericFilter filter);

	ManagedApplicationQuery orMetaRestoreDate(NumericFilter filter);

	ManagedApplicationQuery metaRestoredBy(NumericFilter filter);

	ManagedApplicationQuery orMetaRestoredBy(NumericFilter filter);

	ManagedApplicationQuery filterMainApplication(ApplicationQuery query);

	ManagedApplicationQuery mainApplication(NumericFilter filter);

	ManagedApplicationQuery orMainApplication(NumericFilter filter);

	ManagedApplicationQuery filterOrganizationField(OrganizationFieldQuery query);

	ManagedApplicationQuery organizationField(NumericFilter filter);

	ManagedApplicationQuery orOrganizationField(NumericFilter filter);

	ManagedApplicationQuery icon(TextFilter filter);

	ManagedApplicationQuery orIcon(TextFilter filter);

	ManagedApplicationQuery titleKey(TextFilter filter);

	ManagedApplicationQuery orTitleKey(TextFilter filter);

	ManagedApplicationQuery descriptionKey(TextFilter filter);

	ManagedApplicationQuery orDescriptionKey(TextFilter filter);

	ManagedApplicationQuery singleApplication(BooleanFilter filter);

	ManagedApplicationQuery orSingleApplication(BooleanFilter filter);

	ManagedApplicationQuery darkTheme(BooleanFilter filter);

	ManagedApplicationQuery orDarkTheme(BooleanFilter filter);

	ManagedApplicationQuery startOnLogin(BooleanFilter filter);

	ManagedApplicationQuery orStartOnLogin(BooleanFilter filter);

	ManagedApplicationQuery filterPerspectives(ManagedApplicationPerspectiveQuery query);

	ManagedApplicationQuery perspectives(MultiReferenceFilterType type, ManagedApplicationPerspective ... value);

	ManagedApplicationQuery perspectivesCount(MultiReferenceFilterType type, int count);

	ManagedApplicationQuery perspectives(MultiReferenceFilter filter);

	ManagedApplicationQuery orPerspectives(MultiReferenceFilter filter);

	ManagedApplicationQuery listingPosition(NumericFilter filter);

	ManagedApplicationQuery orListingPosition(NumericFilter filter);

	ManagedApplicationQuery toolbarApplicationMenu(BooleanFilter filter);

	ManagedApplicationQuery orToolbarApplicationMenu(BooleanFilter filter);

	ManagedApplicationQuery filterApplicationGroup(ManagedApplicationGroupQuery query);

	ManagedApplicationQuery applicationGroup(NumericFilter filter);

	ManagedApplicationQuery orApplicationGroup(NumericFilter filter);

	ManagedApplicationQuery hidden(BooleanFilter filter);

	ManagedApplicationQuery orHidden(BooleanFilter filter);


    ManagedApplicationQuery andOr(ManagedApplicationQuery... queries);

    ManagedApplicationQuery customFilter(Function<ManagedApplication, Boolean> customFilter);

    List<ManagedApplication> execute();

    List<ManagedApplication> executeOnDeletedRecords();

    ManagedApplication executeExpectSingleton();

    BitSet executeToBitSet();

    List<ManagedApplication> execute(String sortFieldName, boolean ascending, String ... path);

    List<ManagedApplication> execute(int startIndex, int length, Sorting sorting);

}

