package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface RolePrivilegeAssignment extends Entity<RolePrivilegeAssignment> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_ROLE = "role";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_PRIVILEGE_GROUP = "privilegeGroup";
	final static String FIELD_PRIVILEGES = "privileges";
	final static String FIELD_PRIVILEGE_OBJECTS = "privilegeObjects";
	final static String FIELD_PRIVILEGE_OBJECT_INHERITANCE = "privilegeObjectInheritance";
	final static String FIELD_ORGANIZATION_FIELD_FILTER = "organizationFieldFilter";
	final static String FIELD_FIXED_ORGANIZATION_ROOT = "fixedOrganizationRoot";
	final static String FIELD_ORGANIZATION_UNIT_TYPE_FILTER = "organizationUnitTypeFilter";

    static RolePrivilegeAssignment create() {
        return new UdbRolePrivilegeAssignment();
    }

    static RolePrivilegeAssignment create(int id) {
        return new UdbRolePrivilegeAssignment(id, true);
    }

    static RolePrivilegeAssignment getById(int id) {
        return new UdbRolePrivilegeAssignment(id, false);
    }

    static EntityBuilder<RolePrivilegeAssignment> getBuilder() {
        return new UdbRolePrivilegeAssignment(0, false);
    }

    Instant getMetaCreationDate();

    RolePrivilegeAssignment setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    RolePrivilegeAssignment setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    RolePrivilegeAssignment setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    RolePrivilegeAssignment setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    RolePrivilegeAssignment setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    RolePrivilegeAssignment setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    RolePrivilegeAssignment setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    RolePrivilegeAssignment setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    RolePrivilegeAssignment setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    RolePrivilegeAssignment setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    RolePrivilegeAssignment setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    RolePrivilegeAssignment setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    RolePrivilegeAssignment setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    RolePrivilegeAssignment setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    RolePrivilegeAssignment setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    RolePrivilegeAssignment setMetaRestoredBy(int value);

    Role getRole();

    RolePrivilegeAssignment setRole(Role value);

    Application getApplication();

    RolePrivilegeAssignment setApplication(Application value);

    ApplicationPrivilegeGroup getPrivilegeGroup();

    RolePrivilegeAssignment setPrivilegeGroup(ApplicationPrivilegeGroup value);

    List<ApplicationPrivilege> getPrivileges();

    RolePrivilegeAssignment setPrivileges(List<ApplicationPrivilege> value);

    int getPrivilegesCount();

    RolePrivilegeAssignment setPrivileges(ApplicationPrivilege ... value);

    BitSet getPrivilegesAsBitSet();

    RolePrivilegeAssignment addPrivileges(List<ApplicationPrivilege> value);

    RolePrivilegeAssignment addPrivileges(ApplicationPrivilege ... value);

    RolePrivilegeAssignment removePrivileges(List<ApplicationPrivilege> value);

    RolePrivilegeAssignment removePrivileges(ApplicationPrivilege ... value);

    RolePrivilegeAssignment removeAllPrivileges();

    String getPrivilegeObjects();

    RolePrivilegeAssignment setPrivilegeObjects(String value);

    boolean getPrivilegeObjectInheritance();

    RolePrivilegeAssignment setPrivilegeObjectInheritance(boolean value);

    boolean isPrivilegeObjectInheritance();

    OrganizationField getOrganizationFieldFilter();

    RolePrivilegeAssignment setOrganizationFieldFilter(OrganizationField value);

    OrganizationUnit getFixedOrganizationRoot();

    RolePrivilegeAssignment setFixedOrganizationRoot(OrganizationUnit value);

    List<OrganizationUnitType> getOrganizationUnitTypeFilter();

    RolePrivilegeAssignment setOrganizationUnitTypeFilter(List<OrganizationUnitType> value);

    int getOrganizationUnitTypeFilterCount();

    RolePrivilegeAssignment setOrganizationUnitTypeFilter(OrganizationUnitType ... value);

    BitSet getOrganizationUnitTypeFilterAsBitSet();

    RolePrivilegeAssignment addOrganizationUnitTypeFilter(List<OrganizationUnitType> value);

    RolePrivilegeAssignment addOrganizationUnitTypeFilter(OrganizationUnitType ... value);

    RolePrivilegeAssignment removeOrganizationUnitTypeFilter(List<OrganizationUnitType> value);

    RolePrivilegeAssignment removeOrganizationUnitTypeFilter(OrganizationUnitType ... value);

    RolePrivilegeAssignment removeAllOrganizationUnitTypeFilter();


    static List<RolePrivilegeAssignment> getAll() {
        return UdbRolePrivilegeAssignment.getAll();
    }

    static List<RolePrivilegeAssignment> getDeletedRecords() {
        return UdbRolePrivilegeAssignment.getDeletedRecords();
    }

    static List<RolePrivilegeAssignment> sort(List<RolePrivilegeAssignment> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbRolePrivilegeAssignment.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbRolePrivilegeAssignment.getCount();
    }

    static RolePrivilegeAssignmentQuery filter() {
        return new UdbRolePrivilegeAssignmentQuery();
    }
}

