package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface RolePrivilegeAssignmentQuery extends Query<RolePrivilegeAssignment> {

    static RolePrivilegeAssignmentQuery create() {
        return new UdbRolePrivilegeAssignmentQuery();
    }

    RolePrivilegeAssignmentQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    RolePrivilegeAssignmentQuery parseFullTextFilter(String query, String... fieldNames);

	RolePrivilegeAssignmentQuery metaCreationDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaCreationDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery metaCreatedBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaCreatedBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery metaModificationDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaModificationDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery metaModifiedBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaModifiedBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery metaDeletionDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaDeletionDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery metaDeletedBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaDeletedBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery metaRestoreDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaRestoreDate(NumericFilter filter);

	RolePrivilegeAssignmentQuery metaRestoredBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery orMetaRestoredBy(NumericFilter filter);

	RolePrivilegeAssignmentQuery filterRole(RoleQuery query);

	RolePrivilegeAssignmentQuery role(NumericFilter filter);

	RolePrivilegeAssignmentQuery orRole(NumericFilter filter);

	RolePrivilegeAssignmentQuery filterApplication(ApplicationQuery query);

	RolePrivilegeAssignmentQuery application(NumericFilter filter);

	RolePrivilegeAssignmentQuery orApplication(NumericFilter filter);

	RolePrivilegeAssignmentQuery filterPrivilegeGroup(ApplicationPrivilegeGroupQuery query);

	RolePrivilegeAssignmentQuery privilegeGroup(NumericFilter filter);

	RolePrivilegeAssignmentQuery orPrivilegeGroup(NumericFilter filter);

	RolePrivilegeAssignmentQuery filterPrivileges(ApplicationPrivilegeQuery query);

	RolePrivilegeAssignmentQuery privileges(MultiReferenceFilterType type, ApplicationPrivilege ... value);

	RolePrivilegeAssignmentQuery privilegesCount(MultiReferenceFilterType type, int count);

	RolePrivilegeAssignmentQuery privileges(MultiReferenceFilter filter);

	RolePrivilegeAssignmentQuery orPrivileges(MultiReferenceFilter filter);

	RolePrivilegeAssignmentQuery privilegeObjects(TextFilter filter);

	RolePrivilegeAssignmentQuery orPrivilegeObjects(TextFilter filter);

	RolePrivilegeAssignmentQuery privilegeObjectInheritance(BooleanFilter filter);

	RolePrivilegeAssignmentQuery orPrivilegeObjectInheritance(BooleanFilter filter);

	RolePrivilegeAssignmentQuery filterOrganizationFieldFilter(OrganizationFieldQuery query);

	RolePrivilegeAssignmentQuery organizationFieldFilter(NumericFilter filter);

	RolePrivilegeAssignmentQuery orOrganizationFieldFilter(NumericFilter filter);

	RolePrivilegeAssignmentQuery filterFixedOrganizationRoot(OrganizationUnitQuery query);

	RolePrivilegeAssignmentQuery fixedOrganizationRoot(NumericFilter filter);

	RolePrivilegeAssignmentQuery orFixedOrganizationRoot(NumericFilter filter);

	RolePrivilegeAssignmentQuery filterOrganizationUnitTypeFilter(OrganizationUnitTypeQuery query);

	RolePrivilegeAssignmentQuery organizationUnitTypeFilter(MultiReferenceFilterType type, OrganizationUnitType ... value);

	RolePrivilegeAssignmentQuery organizationUnitTypeFilterCount(MultiReferenceFilterType type, int count);

	RolePrivilegeAssignmentQuery organizationUnitTypeFilter(MultiReferenceFilter filter);

	RolePrivilegeAssignmentQuery orOrganizationUnitTypeFilter(MultiReferenceFilter filter);


    RolePrivilegeAssignmentQuery andOr(RolePrivilegeAssignmentQuery... queries);

    RolePrivilegeAssignmentQuery customFilter(Function<RolePrivilegeAssignment, Boolean> customFilter);

    List<RolePrivilegeAssignment> execute();

    List<RolePrivilegeAssignment> executeOnDeletedRecords();

    RolePrivilegeAssignment executeExpectSingleton();

    BitSet executeToBitSet();

    List<RolePrivilegeAssignment> execute(String sortFieldName, boolean ascending, String ... path);

    List<RolePrivilegeAssignment> execute(int startIndex, int length, Sorting sorting);

}

