package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface SystemLog extends Entity<SystemLog> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_MANAGED_APPLICATION = "managedApplication";
	final static String FIELD_MANAGED_PERSPECTIVE = "managedPerspective";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_APPLICATION_PERSPECTIVE = "applicationPerspective";
	final static String FIELD_APPLICATION_VERSION = "applicationVersion";
	final static String FIELD_LOG_LEVEL = "logLevel";
	final static String FIELD_THREAD = "thread";
	final static String FIELD_MESSAGE = "message";
	final static String FIELD_DETAILS = "details";
	final static String FIELD_EXCEPTION_CLASS = "exceptionClass";

    static SystemLog create() {
        return new UdbSystemLog();
    }

    static SystemLog create(int id) {
        return new UdbSystemLog(id, true);
    }

    static SystemLog getById(int id) {
        return new UdbSystemLog(id, false);
    }

    static EntityBuilder<SystemLog> getBuilder() {
        return new UdbSystemLog(0, false);
    }

    Instant getMetaCreationDate();

    SystemLog setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    SystemLog setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    SystemLog setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    SystemLog setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    SystemLog setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    SystemLog setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    SystemLog setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    SystemLog setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    SystemLog setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    SystemLog setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    SystemLog setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    SystemLog setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    SystemLog setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    SystemLog setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    SystemLog setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    SystemLog setMetaRestoredBy(int value);

    ManagedApplication getManagedApplication();

    SystemLog setManagedApplication(ManagedApplication value);

    ManagedApplicationPerspective getManagedPerspective();

    SystemLog setManagedPerspective(ManagedApplicationPerspective value);

    Application getApplication();

    SystemLog setApplication(Application value);

    ApplicationPerspective getApplicationPerspective();

    SystemLog setApplicationPerspective(ApplicationPerspective value);

    ApplicationVersion getApplicationVersion();

    SystemLog setApplicationVersion(ApplicationVersion value);

    LogLevel getLogLevel();

    SystemLog setLogLevel(LogLevel value);

    String getThread();

    SystemLog setThread(String value);

    String getMessage();

    SystemLog setMessage(String value);

    String getDetails();

    SystemLog setDetails(String value);

    String getExceptionClass();

    SystemLog setExceptionClass(String value);


    static List<SystemLog> getAll() {
        return UdbSystemLog.getAll();
    }

    static List<SystemLog> getDeletedRecords() {
        return UdbSystemLog.getDeletedRecords();
    }

    static List<SystemLog> sort(List<SystemLog> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbSystemLog.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbSystemLog.getCount();
    }

    static SystemLogQuery filter() {
        return new UdbSystemLogQuery();
    }
}

