package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbApplicationFolderQuery extends AbstractUdbQuery<ApplicationFolder> implements ApplicationFolderQuery {

    public UdbApplicationFolderQuery() {
        super(UdbApplicationFolder.table, ApplicationFolder.getBuilder());
    }

	@Override
	public ApplicationFolderQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbApplicationFolder.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ApplicationFolderQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbApplicationFolder.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaCreationDate(NumericFilter filter) {
		and(UdbApplicationFolder.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbApplicationFolder.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaCreatedBy(NumericFilter filter) {
		and(UdbApplicationFolder.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbApplicationFolder.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaModificationDate(NumericFilter filter) {
		and(UdbApplicationFolder.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbApplicationFolder.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaModifiedBy(NumericFilter filter) {
		and(UdbApplicationFolder.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbApplicationFolder.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaDeletionDate(NumericFilter filter) {
		and(UdbApplicationFolder.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbApplicationFolder.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaDeletedBy(NumericFilter filter) {
		and(UdbApplicationFolder.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbApplicationFolder.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaRestoreDate(NumericFilter filter) {
		and(UdbApplicationFolder.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbApplicationFolder.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery metaRestoredBy(NumericFilter filter) {
		and(UdbApplicationFolder.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbApplicationFolder.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery name(TextFilter filter) {
		and(UdbApplicationFolder.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orName(TextFilter filter) {
		or(UdbApplicationFolder.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationFolder.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationFolderQuery application(NumericFilter filter) {
		and(UdbApplicationFolder.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orApplication(NumericFilter filter) {
		or(UdbApplicationFolder.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery applicationFolderType(EnumFilterType filterType, ApplicationFolderType... enums) {
		and(UdbApplicationFolder.applicationFolderType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public ApplicationFolderQuery orApplicationFolderType(EnumFilterType filterType, ApplicationFolderType... enums) {
		or(UdbApplicationFolder.applicationFolderType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public ApplicationFolderQuery filterParent(ApplicationFolderQuery query) {
		UdbApplicationFolderQuery udbQuery = (UdbApplicationFolderQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationFolder.parent, UdbApplicationFolder.children);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationFolderQuery parent(NumericFilter filter) {
		and(UdbApplicationFolder.parent.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orParent(NumericFilter filter) {
		or(UdbApplicationFolder.parent.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery filterChildren(ApplicationFolderQuery query) {
		UdbApplicationFolderQuery udbQuery = (UdbApplicationFolderQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationFolder.children, UdbApplicationFolder.parent);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationFolderQuery children(MultiReferenceFilterType type, ApplicationFolder ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ApplicationFolder value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplicationFolder.children.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery childrenCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplicationFolder.children.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery children(MultiReferenceFilter filter) {
		and(UdbApplicationFolder.children.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orChildren(MultiReferenceFilter filter) {
		or(UdbApplicationFolder.children.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery filterMessages(MessageQuery query) {
		UdbMessageQuery udbQuery = (UdbMessageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationFolder.messages, UdbMessage.applicationFolder);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationFolderQuery messages(MultiReferenceFilterType type, Message ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Message value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplicationFolder.messages.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery messagesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplicationFolder.messages.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery messages(MultiReferenceFilter filter) {
		and(UdbApplicationFolder.messages.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationFolderQuery orMessages(MultiReferenceFilter filter) {
		or(UdbApplicationFolder.messages.createFilter(filter));
		return this;
	}


	@Override
	public UdbApplicationFolderQuery andOr(ApplicationFolderQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ApplicationFolderQuery customFilter(Function<ApplicationFolder, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ApplicationFolder.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



