package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbAppointment extends AbstractUdbEntity<Appointment> implements Appointment {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex message;
	protected static SingleReferenceIndex appointmentSeries;
	protected static BooleanIndex webConference;
	protected static LongIndex startDateTime;
	protected static LongIndex endDateTime;
	protected static BooleanIndex fullDayEvent;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		message = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_MESSAGE);
		appointmentSeries = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPOINTMENT_SERIES);
		webConference = (BooleanIndex) tableIndex.getColumnIndex(FIELD_WEB_CONFERENCE);
		startDateTime = (LongIndex) tableIndex.getColumnIndex(FIELD_START_DATE_TIME);
		endDateTime = (LongIndex) tableIndex.getColumnIndex(FIELD_END_DATE_TIME);
		fullDayEvent = (BooleanIndex) tableIndex.getColumnIndex(FIELD_FULL_DAY_EVENT);
    }

    public static List<Appointment> getAll() {
        return new EntityBitSetList<>(Appointment.getBuilder(), table.getRecordBitSet());
    }

    public static List<Appointment> getDeletedRecords() {
        return new EntityBitSetList<>(Appointment.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Appointment> sort(List<Appointment> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<Appointment> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, Appointment.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAppointment() {
        super(table);
    }

    public UdbAppointment(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Appointment build() {
        return new UdbAppointment();
    }

    @Override
    public Appointment build(int id) {
        return new UdbAppointment(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Appointment setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Appointment setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Appointment setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Appointment setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Appointment setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Appointment setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Appointment setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Appointment setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Appointment setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Appointment setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Appointment setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Appointment setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public Appointment setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public Appointment setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public Appointment setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public Appointment setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public Message getMessage() {
		if (isChanged(message)) {
			return (Message) getReferenceChangeValue(message);
		} else {
			int id = message.getValue(getId());
			if (id > 0) {
				return Message.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Appointment setMessage(Message value) {
		setSingleReferenceValue(message, value, table);
		return this;
	}

	@Override
	public AppointmentSeries getAppointmentSeries() {
		if (isChanged(appointmentSeries)) {
			return (AppointmentSeries) getReferenceChangeValue(appointmentSeries);
		} else {
			int id = appointmentSeries.getValue(getId());
			if (id > 0) {
				return AppointmentSeries.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Appointment setAppointmentSeries(AppointmentSeries value) {
		setSingleReferenceValue(appointmentSeries, value, table);
		return this;
	}

	@Override
	public boolean getWebConference() {
	    return getBooleanValue(webConference);
	}

	@Override
	public Appointment setWebConference(boolean value) {
	    setBooleanValue(value, this.webConference);
		return this;
	}

	@Override
	public boolean isWebConference() {
	    return getBooleanValue(webConference);
	}

	@Override
	public Instant getStartDateTime() {
	    return getDateTimeValue(startDateTime);
	}

	@Override
	public Appointment setStartDateTime(Instant value) {
	    setDateTimeValue(value, this.startDateTime);
		return this;
	}

	@Override
	public long getStartDateTimeAsEpochMilli() {
	    return getDateTimeAsEpochMilli(startDateTime);
	}

	@Override
	public Appointment setStartDateTimeAsEpochMilli(long value) {
	    setDateTimeAsEpochMilli(value, this.startDateTime);
		return this;
	}

	@Override
	public Instant getEndDateTime() {
	    return getDateTimeValue(endDateTime);
	}

	@Override
	public Appointment setEndDateTime(Instant value) {
	    setDateTimeValue(value, this.endDateTime);
		return this;
	}

	@Override
	public long getEndDateTimeAsEpochMilli() {
	    return getDateTimeAsEpochMilli(endDateTime);
	}

	@Override
	public Appointment setEndDateTimeAsEpochMilli(long value) {
	    setDateTimeAsEpochMilli(value, this.endDateTime);
		return this;
	}

	@Override
	public boolean getFullDayEvent() {
	    return getBooleanValue(fullDayEvent);
	}

	@Override
	public Appointment setFullDayEvent(boolean value) {
	    setBooleanValue(value, this.fullDayEvent);
		return this;
	}

	@Override
	public boolean isFullDayEvent() {
	    return getBooleanValue(fullDayEvent);
	}


    @Override
    public UdbAppointment save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbAppointment saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbAppointment save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



