package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbAppointmentSeries extends AbstractUdbEntity<AppointmentSeries> implements AppointmentSeries {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex message;
	protected static MultiReferenceIndex appointments;
	protected static ShortIndex appointmentSeriesType;
	protected static IntegerIndex repeatEvery;
	protected static LongIndex startDateTime;
	protected static LongIndex endDateTime;
	protected static BooleanIndex fullDayEvent;
	protected static LongIndex seriesEndDate;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		message = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_MESSAGE);
		appointments = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_APPOINTMENTS);
		appointmentSeriesType = (ShortIndex) tableIndex.getColumnIndex(FIELD_APPOINTMENT_SERIES_TYPE);
		repeatEvery = (IntegerIndex) tableIndex.getColumnIndex(FIELD_REPEAT_EVERY);
		startDateTime = (LongIndex) tableIndex.getColumnIndex(FIELD_START_DATE_TIME);
		endDateTime = (LongIndex) tableIndex.getColumnIndex(FIELD_END_DATE_TIME);
		fullDayEvent = (BooleanIndex) tableIndex.getColumnIndex(FIELD_FULL_DAY_EVENT);
		seriesEndDate = (LongIndex) tableIndex.getColumnIndex(FIELD_SERIES_END_DATE);
    }

    public static List<AppointmentSeries> getAll() {
        return new EntityBitSetList<>(AppointmentSeries.getBuilder(), table.getRecordBitSet());
    }

    public static List<AppointmentSeries> getDeletedRecords() {
        return new EntityBitSetList<>(AppointmentSeries.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<AppointmentSeries> sort(List<AppointmentSeries> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<AppointmentSeries> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, AppointmentSeries.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAppointmentSeries() {
        super(table);
    }

    public UdbAppointmentSeries(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public AppointmentSeries build() {
        return new UdbAppointmentSeries();
    }

    @Override
    public AppointmentSeries build(int id) {
        return new UdbAppointmentSeries(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public AppointmentSeries setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public AppointmentSeries setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public AppointmentSeries setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public AppointmentSeries setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public AppointmentSeries setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public AppointmentSeries setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public AppointmentSeries setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public AppointmentSeries setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public AppointmentSeries setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public AppointmentSeries setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public AppointmentSeries setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public AppointmentSeries setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public AppointmentSeries setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public AppointmentSeries setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public AppointmentSeries setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public AppointmentSeries setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public Message getMessage() {
		if (isChanged(message)) {
			return (Message) getReferenceChangeValue(message);
		} else {
			int id = message.getValue(getId());
			if (id > 0) {
				return Message.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public AppointmentSeries setMessage(Message value) {
		setSingleReferenceValue(message, value, table);
		return this;
	}

	@Override
	public List<Appointment> getAppointments() {
	    return getMultiReferenceValue(appointments, Appointment.getBuilder());
	}

	@Override
	public AppointmentSeries setAppointments(List<Appointment> value) {
		setMultiReferenceValue(value, appointments);
		return this;
	}

	@Override
	public int getAppointmentsCount() {
	    return getMultiReferenceValueCount(appointments, Appointment.getBuilder());
	}

	@Override
	public AppointmentSeries setAppointments(Appointment ... value) {
		setMultiReferenceValue(Arrays.asList(value), appointments);
		return this;
	}

	@Override
	public BitSet getAppointmentsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(appointments, Appointment.getBuilder());
	}

	@Override
	public AppointmentSeries addAppointments(List<Appointment> value) {
		addMultiReferenceValue(value, appointments);
		return this;
	}

	@Override
	public AppointmentSeries addAppointments(Appointment ... value) {
		addMultiReferenceValue(Arrays.asList(value), appointments);
		return this;
	}

	@Override
	public AppointmentSeries removeAppointments(List<Appointment> value) {
		removeMultiReferenceValue(value, appointments);
		return this;
	}

	@Override
	public AppointmentSeries removeAppointments(Appointment ... value) {
		removeMultiReferenceValue(Arrays.asList(value), appointments);
		return this;
	}

	@Override
	public AppointmentSeries removeAllAppointments() {
		removeAllMultiReferenceValue(appointments);
		return this;
	}

	@Override
	public AppointmentSeriesType getAppointmentSeriesType() {
	    return getEnumValue(appointmentSeriesType, AppointmentSeriesType.values());
	}

	@Override
	public AppointmentSeries setAppointmentSeriesType(AppointmentSeriesType value) {
    	setEnumValue(this.appointmentSeriesType, value);
		return this;
	}

	@Override
	public int getRepeatEvery() {
        return getIntValue(repeatEvery);
	}

	@Override
	public AppointmentSeries setRepeatEvery(int value) {
	    setIntValue(value, this.repeatEvery);
		return this;
	}

	@Override
	public Instant getStartDateTime() {
	    return getDateTimeValue(startDateTime);
	}

	@Override
	public AppointmentSeries setStartDateTime(Instant value) {
	    setDateTimeValue(value, this.startDateTime);
		return this;
	}

	@Override
	public long getStartDateTimeAsEpochMilli() {
	    return getDateTimeAsEpochMilli(startDateTime);
	}

	@Override
	public AppointmentSeries setStartDateTimeAsEpochMilli(long value) {
	    setDateTimeAsEpochMilli(value, this.startDateTime);
		return this;
	}

	@Override
	public Instant getEndDateTime() {
	    return getDateTimeValue(endDateTime);
	}

	@Override
	public AppointmentSeries setEndDateTime(Instant value) {
	    setDateTimeValue(value, this.endDateTime);
		return this;
	}

	@Override
	public long getEndDateTimeAsEpochMilli() {
	    return getDateTimeAsEpochMilli(endDateTime);
	}

	@Override
	public AppointmentSeries setEndDateTimeAsEpochMilli(long value) {
	    setDateTimeAsEpochMilli(value, this.endDateTime);
		return this;
	}

	@Override
	public boolean getFullDayEvent() {
	    return getBooleanValue(fullDayEvent);
	}

	@Override
	public AppointmentSeries setFullDayEvent(boolean value) {
	    setBooleanValue(value, this.fullDayEvent);
		return this;
	}

	@Override
	public boolean isFullDayEvent() {
	    return getBooleanValue(fullDayEvent);
	}

	@Override
	public LocalDate getSeriesEndDate() {
	    return getLocalDateValue(seriesEndDate);
	}

	@Override
	public AppointmentSeries setSeriesEndDate(LocalDate value) {
	    setLocalDateValue(value, this.seriesEndDate);
		return this;
	}

	@Override
	public long getSeriesEndDateAsEpochMilli() {
    	if (isChanged(seriesEndDate)) {
			return (long) getChangedValue(seriesEndDate);
		} else {
			return seriesEndDate.getValue(getId());
		}
	}

	@Override
	public AppointmentSeries setSeriesEndDateAsEpochMilli(long value) {
	    setLocalDateAsEpochMilli(value, this.seriesEndDate);
		setChangeValue(this.seriesEndDate, value, table);
		return this;
	}


    @Override
    public UdbAppointmentSeries save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbAppointmentSeries saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbAppointmentSeries save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



