package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbCountryQuery extends AbstractUdbQuery<Country> implements CountryQuery {

    public UdbCountryQuery() {
        super(UdbCountry.table, Country.getBuilder());
    }

	@Override
	public CountryQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbCountry.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public CountryQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbCountry.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public CountryQuery metaCreationDate(NumericFilter filter) {
		and(UdbCountry.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbCountry.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery metaCreatedBy(NumericFilter filter) {
		and(UdbCountry.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbCountry.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery metaModificationDate(NumericFilter filter) {
		and(UdbCountry.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbCountry.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery metaModifiedBy(NumericFilter filter) {
		and(UdbCountry.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbCountry.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery metaDeletionDate(NumericFilter filter) {
		and(UdbCountry.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbCountry.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery metaDeletedBy(NumericFilter filter) {
		and(UdbCountry.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbCountry.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery metaRestoreDate(NumericFilter filter) {
		and(UdbCountry.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbCountry.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery metaRestoredBy(NumericFilter filter) {
		and(UdbCountry.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbCountry.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery isoCode(TextFilter filter) {
		and(UdbCountry.isoCode.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orIsoCode(TextFilter filter) {
		or(UdbCountry.isoCode.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery icon(TextFilter filter) {
		and(UdbCountry.icon.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orIcon(TextFilter filter) {
		or(UdbCountry.icon.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery englishDisplayName(TextFilter filter) {
		and(UdbCountry.englishDisplayName.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orEnglishDisplayName(TextFilter filter) {
		or(UdbCountry.englishDisplayName.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery filterLocalizationKey(LocalizationKeyQuery query) {
		UdbLocalizationKeyQuery udbQuery = (UdbLocalizationKeyQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbCountry.localizationKey);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public CountryQuery localizationKey(NumericFilter filter) {
		and(UdbCountry.localizationKey.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orLocalizationKey(NumericFilter filter) {
		or(UdbCountry.localizationKey.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery addressFormat(TextFilter filter) {
		and(UdbCountry.addressFormat.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orAddressFormat(TextFilter filter) {
		or(UdbCountry.addressFormat.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery filterMainLanguage(LanguageQuery query) {
		UdbLanguageQuery udbQuery = (UdbLanguageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbCountry.mainLanguage);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public CountryQuery mainLanguage(NumericFilter filter) {
		and(UdbCountry.mainLanguage.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orMainLanguage(NumericFilter filter) {
		or(UdbCountry.mainLanguage.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery filterOtherLanguages(LanguageQuery query) {
		UdbLanguageQuery udbQuery = (UdbLanguageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbCountry.otherLanguages);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public CountryQuery otherLanguages(MultiReferenceFilterType type, Language ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Language value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbCountry.otherLanguages.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery otherLanguagesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbCountry.otherLanguages.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery otherLanguages(MultiReferenceFilter filter) {
		and(UdbCountry.otherLanguages.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orOtherLanguages(MultiReferenceFilter filter) {
		or(UdbCountry.otherLanguages.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery filterCurrency(CurrencyQuery query) {
		UdbCurrencyQuery udbQuery = (UdbCurrencyQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbCountry.currency);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public CountryQuery currency(NumericFilter filter) {
		and(UdbCountry.currency.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orCurrency(NumericFilter filter) {
		or(UdbCountry.currency.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery filterOtherCurrencies(CurrencyQuery query) {
		UdbCurrencyQuery udbQuery = (UdbCurrencyQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbCountry.otherCurrencies);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public CountryQuery otherCurrencies(MultiReferenceFilterType type, Currency ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Currency value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbCountry.otherCurrencies.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery otherCurrenciesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbCountry.otherCurrencies.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery otherCurrencies(MultiReferenceFilter filter) {
		and(UdbCountry.otherCurrencies.createFilter(filter));
		return this;
	}

	@Override
	public CountryQuery orOtherCurrencies(MultiReferenceFilter filter) {
		or(UdbCountry.otherCurrencies.createFilter(filter));
		return this;
	}


	@Override
	public UdbCountryQuery andOr(CountryQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public CountryQuery customFilter(Function<Country, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Country.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



