package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbGroup extends AbstractUdbEntity<Group> implements Group {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static ShortIndex groupType;
	protected static TextIndex name;
	protected static TextIndex description;
	protected static TextIndex language;
	protected static SingleReferenceIndex organizationField;
	protected static SingleReferenceIndex organizationUnit;
	protected static SingleReferenceIndex owner;
	protected static MultiReferenceIndex moderators;
	protected static MultiReferenceIndex mentors;
	protected static BooleanIndex valid;
	protected static MultiReferenceIndex membershipDefinitions;
	protected static MultiReferenceIndex registrationAllowedForDefinitions;
	protected static MultiReferenceIndex userMemberships;
	protected static IntegerIndex lastMessageDate;
	protected static MultiReferenceIndex groupFolders;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		groupType = (ShortIndex) tableIndex.getColumnIndex(FIELD_GROUP_TYPE);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		description = (TextIndex) tableIndex.getColumnIndex(FIELD_DESCRIPTION);
		language = (TextIndex) tableIndex.getColumnIndex(FIELD_LANGUAGE);
		organizationField = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_FIELD);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
		owner = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_OWNER);
		moderators = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_MODERATORS);
		mentors = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_MENTORS);
		valid = (BooleanIndex) tableIndex.getColumnIndex(FIELD_VALID);
		membershipDefinitions = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_MEMBERSHIP_DEFINITIONS);
		registrationAllowedForDefinitions = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_REGISTRATION_ALLOWED_FOR_DEFINITIONS);
		userMemberships = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_USER_MEMBERSHIPS);
		lastMessageDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_LAST_MESSAGE_DATE);
		groupFolders = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_GROUP_FOLDERS);
    }

    public static List<Group> getAll() {
        return new EntityBitSetList<>(Group.getBuilder(), table.getRecordBitSet());
    }

    public static List<Group> getDeletedRecords() {
        return new EntityBitSetList<>(Group.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Group> sort(List<Group> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<Group> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, Group.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbGroup() {
        super(table);
    }

    public UdbGroup(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Group build() {
        return new UdbGroup();
    }

    @Override
    public Group build(int id) {
        return new UdbGroup(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Group setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Group setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Group setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Group setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Group setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Group setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Group setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Group setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Group setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Group setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Group setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Group setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public Group setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public Group setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public Group setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public Group setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public GroupType getGroupType() {
	    return getEnumValue(groupType, GroupType.values());
	}

	@Override
	public Group setGroupType(GroupType value) {
    	setEnumValue(this.groupType, value);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public Group setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public String getDescription() {
        return getTextValue(description);
	}

	@Override
	public Group setDescription(String value) {
	    setTextValue(value, this.description);
		return this;
	}

	@Override
	public String getLanguage() {
        return getTextValue(language);
	}

	@Override
	public Group setLanguage(String value) {
	    setTextValue(value, this.language);
		return this;
	}

	@Override
	public OrganizationField getOrganizationField() {
		if (isChanged(organizationField)) {
			return (OrganizationField) getReferenceChangeValue(organizationField);
		} else {
			int id = organizationField.getValue(getId());
			if (id > 0) {
				return OrganizationField.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Group setOrganizationField(OrganizationField value) {
		setSingleReferenceValue(organizationField, value, table);
		return this;
	}

	@Override
	public OrganizationUnit getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnit) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Group setOrganizationUnit(OrganizationUnit value) {
		setSingleReferenceValue(organizationUnit, value, table);
		return this;
	}

	@Override
	public User getOwner() {
		if (isChanged(owner)) {
			return (User) getReferenceChangeValue(owner);
		} else {
			int id = owner.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Group setOwner(User value) {
		setSingleReferenceValue(owner, value, table);
		return this;
	}

	@Override
	public List<User> getModerators() {
	    return getMultiReferenceValue(moderators, User.getBuilder());
	}

	@Override
	public Group setModerators(List<User> value) {
		setMultiReferenceValue(value, moderators);
		return this;
	}

	@Override
	public int getModeratorsCount() {
	    return getMultiReferenceValueCount(moderators, User.getBuilder());
	}

	@Override
	public Group setModerators(User ... value) {
		setMultiReferenceValue(Arrays.asList(value), moderators);
		return this;
	}

	@Override
	public BitSet getModeratorsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(moderators, User.getBuilder());
	}

	@Override
	public Group addModerators(List<User> value) {
		addMultiReferenceValue(value, moderators);
		return this;
	}

	@Override
	public Group addModerators(User ... value) {
		addMultiReferenceValue(Arrays.asList(value), moderators);
		return this;
	}

	@Override
	public Group removeModerators(List<User> value) {
		removeMultiReferenceValue(value, moderators);
		return this;
	}

	@Override
	public Group removeModerators(User ... value) {
		removeMultiReferenceValue(Arrays.asList(value), moderators);
		return this;
	}

	@Override
	public Group removeAllModerators() {
		removeAllMultiReferenceValue(moderators);
		return this;
	}

	@Override
	public List<User> getMentors() {
	    return getMultiReferenceValue(mentors, User.getBuilder());
	}

	@Override
	public Group setMentors(List<User> value) {
		setMultiReferenceValue(value, mentors);
		return this;
	}

	@Override
	public int getMentorsCount() {
	    return getMultiReferenceValueCount(mentors, User.getBuilder());
	}

	@Override
	public Group setMentors(User ... value) {
		setMultiReferenceValue(Arrays.asList(value), mentors);
		return this;
	}

	@Override
	public BitSet getMentorsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(mentors, User.getBuilder());
	}

	@Override
	public Group addMentors(List<User> value) {
		addMultiReferenceValue(value, mentors);
		return this;
	}

	@Override
	public Group addMentors(User ... value) {
		addMultiReferenceValue(Arrays.asList(value), mentors);
		return this;
	}

	@Override
	public Group removeMentors(List<User> value) {
		removeMultiReferenceValue(value, mentors);
		return this;
	}

	@Override
	public Group removeMentors(User ... value) {
		removeMultiReferenceValue(Arrays.asList(value), mentors);
		return this;
	}

	@Override
	public Group removeAllMentors() {
		removeAllMultiReferenceValue(mentors);
		return this;
	}

	@Override
	public boolean getValid() {
	    return getBooleanValue(valid);
	}

	@Override
	public Group setValid(boolean value) {
	    setBooleanValue(value, this.valid);
		return this;
	}

	@Override
	public boolean isValid() {
	    return getBooleanValue(valid);
	}

	@Override
	public List<GroupMembershipDefinition> getMembershipDefinitions() {
	    return getMultiReferenceValue(membershipDefinitions, GroupMembershipDefinition.getBuilder());
	}

	@Override
	public Group setMembershipDefinitions(List<GroupMembershipDefinition> value) {
		setMultiReferenceValue(value, membershipDefinitions);
		return this;
	}

	@Override
	public int getMembershipDefinitionsCount() {
	    return getMultiReferenceValueCount(membershipDefinitions, GroupMembershipDefinition.getBuilder());
	}

	@Override
	public Group setMembershipDefinitions(GroupMembershipDefinition ... value) {
		setMultiReferenceValue(Arrays.asList(value), membershipDefinitions);
		return this;
	}

	@Override
	public BitSet getMembershipDefinitionsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(membershipDefinitions, GroupMembershipDefinition.getBuilder());
	}

	@Override
	public Group addMembershipDefinitions(List<GroupMembershipDefinition> value) {
		addMultiReferenceValue(value, membershipDefinitions);
		return this;
	}

	@Override
	public Group addMembershipDefinitions(GroupMembershipDefinition ... value) {
		addMultiReferenceValue(Arrays.asList(value), membershipDefinitions);
		return this;
	}

	@Override
	public Group removeMembershipDefinitions(List<GroupMembershipDefinition> value) {
		removeMultiReferenceValue(value, membershipDefinitions);
		return this;
	}

	@Override
	public Group removeMembershipDefinitions(GroupMembershipDefinition ... value) {
		removeMultiReferenceValue(Arrays.asList(value), membershipDefinitions);
		return this;
	}

	@Override
	public Group removeAllMembershipDefinitions() {
		removeAllMultiReferenceValue(membershipDefinitions);
		return this;
	}

	@Override
	public List<GroupMembershipDefinition> getRegistrationAllowedForDefinitions() {
	    return getMultiReferenceValue(registrationAllowedForDefinitions, GroupMembershipDefinition.getBuilder());
	}

	@Override
	public Group setRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value) {
		setMultiReferenceValue(value, registrationAllowedForDefinitions);
		return this;
	}

	@Override
	public int getRegistrationAllowedForDefinitionsCount() {
	    return getMultiReferenceValueCount(registrationAllowedForDefinitions, GroupMembershipDefinition.getBuilder());
	}

	@Override
	public Group setRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value) {
		setMultiReferenceValue(Arrays.asList(value), registrationAllowedForDefinitions);
		return this;
	}

	@Override
	public BitSet getRegistrationAllowedForDefinitionsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(registrationAllowedForDefinitions, GroupMembershipDefinition.getBuilder());
	}

	@Override
	public Group addRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value) {
		addMultiReferenceValue(value, registrationAllowedForDefinitions);
		return this;
	}

	@Override
	public Group addRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value) {
		addMultiReferenceValue(Arrays.asList(value), registrationAllowedForDefinitions);
		return this;
	}

	@Override
	public Group removeRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value) {
		removeMultiReferenceValue(value, registrationAllowedForDefinitions);
		return this;
	}

	@Override
	public Group removeRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value) {
		removeMultiReferenceValue(Arrays.asList(value), registrationAllowedForDefinitions);
		return this;
	}

	@Override
	public Group removeAllRegistrationAllowedForDefinitions() {
		removeAllMultiReferenceValue(registrationAllowedForDefinitions);
		return this;
	}

	@Override
	public List<UserGroupMembership> getUserMemberships() {
	    return getMultiReferenceValue(userMemberships, UserGroupMembership.getBuilder());
	}

	@Override
	public Group setUserMemberships(List<UserGroupMembership> value) {
		setMultiReferenceValue(value, userMemberships);
		return this;
	}

	@Override
	public int getUserMembershipsCount() {
	    return getMultiReferenceValueCount(userMemberships, UserGroupMembership.getBuilder());
	}

	@Override
	public Group setUserMemberships(UserGroupMembership ... value) {
		setMultiReferenceValue(Arrays.asList(value), userMemberships);
		return this;
	}

	@Override
	public BitSet getUserMembershipsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(userMemberships, UserGroupMembership.getBuilder());
	}

	@Override
	public Group addUserMemberships(List<UserGroupMembership> value) {
		addMultiReferenceValue(value, userMemberships);
		return this;
	}

	@Override
	public Group addUserMemberships(UserGroupMembership ... value) {
		addMultiReferenceValue(Arrays.asList(value), userMemberships);
		return this;
	}

	@Override
	public Group removeUserMemberships(List<UserGroupMembership> value) {
		removeMultiReferenceValue(value, userMemberships);
		return this;
	}

	@Override
	public Group removeUserMemberships(UserGroupMembership ... value) {
		removeMultiReferenceValue(Arrays.asList(value), userMemberships);
		return this;
	}

	@Override
	public Group removeAllUserMemberships() {
		removeAllMultiReferenceValue(userMemberships);
		return this;
	}

	@Override
	public Instant getLastMessageDate() {
	    return getTimestampValue(lastMessageDate);
	}

	@Override
	public Group setLastMessageDate(Instant value) {
	    setTimestampValue(value, this.lastMessageDate);
		return this;
	}

	@Override
	public int getLastMessageDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastMessageDate);
	}

	@Override
	public Group setLastMessageDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastMessageDate);
		return this;
	}

	@Override
	public long getLastMessageDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastMessageDate);
	}

	@Override
	public Group setLastMessageDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastMessageDate);
		return this;
	}

	@Override
	public List<GroupFolder> getGroupFolders() {
	    return getMultiReferenceValue(groupFolders, GroupFolder.getBuilder());
	}

	@Override
	public Group setGroupFolders(List<GroupFolder> value) {
		setMultiReferenceValue(value, groupFolders);
		return this;
	}

	@Override
	public int getGroupFoldersCount() {
	    return getMultiReferenceValueCount(groupFolders, GroupFolder.getBuilder());
	}

	@Override
	public Group setGroupFolders(GroupFolder ... value) {
		setMultiReferenceValue(Arrays.asList(value), groupFolders);
		return this;
	}

	@Override
	public BitSet getGroupFoldersAsBitSet() {
	    return getMultiReferenceValueAsBitSet(groupFolders, GroupFolder.getBuilder());
	}

	@Override
	public Group addGroupFolders(List<GroupFolder> value) {
		addMultiReferenceValue(value, groupFolders);
		return this;
	}

	@Override
	public Group addGroupFolders(GroupFolder ... value) {
		addMultiReferenceValue(Arrays.asList(value), groupFolders);
		return this;
	}

	@Override
	public Group removeGroupFolders(List<GroupFolder> value) {
		removeMultiReferenceValue(value, groupFolders);
		return this;
	}

	@Override
	public Group removeGroupFolders(GroupFolder ... value) {
		removeMultiReferenceValue(Arrays.asList(value), groupFolders);
		return this;
	}

	@Override
	public Group removeAllGroupFolders() {
		removeAllMultiReferenceValue(groupFolders);
		return this;
	}


    @Override
    public UdbGroup save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbGroup saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbGroup save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



