package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbGroupMembershipDefinition extends AbstractUdbEntity<GroupMembershipDefinition> implements GroupMembershipDefinition {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static ShortIndex groupMemberType;
	protected static SingleReferenceIndex user;
	protected static SingleReferenceIndex group;
	protected static SingleReferenceIndex role;
	protected static SingleReferenceIndex organizationUnit;
	protected static MultiReferenceIndex organizationUnitTypesFilter;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		groupMemberType = (ShortIndex) tableIndex.getColumnIndex(FIELD_GROUP_MEMBER_TYPE);
		user = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_USER);
		group = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_GROUP);
		role = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ROLE);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
		organizationUnitTypesFilter = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT_TYPES_FILTER);
    }

    public static List<GroupMembershipDefinition> getAll() {
        return new EntityBitSetList<>(GroupMembershipDefinition.getBuilder(), table.getRecordBitSet());
    }

    public static List<GroupMembershipDefinition> getDeletedRecords() {
        return new EntityBitSetList<>(GroupMembershipDefinition.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<GroupMembershipDefinition> sort(List<GroupMembershipDefinition> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<GroupMembershipDefinition> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, GroupMembershipDefinition.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbGroupMembershipDefinition() {
        super(table);
    }

    public UdbGroupMembershipDefinition(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public GroupMembershipDefinition build() {
        return new UdbGroupMembershipDefinition();
    }

    @Override
    public GroupMembershipDefinition build(int id) {
        return new UdbGroupMembershipDefinition(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public GroupMembershipDefinition setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public GroupMembershipDefinition setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public GroupMembershipDefinition setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public GroupMembershipDefinition setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public GroupMembershipDefinition setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public GroupMembershipDefinition setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public GroupMembershipDefinition setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public GroupMembershipDefinition setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public GroupMembershipDefinition setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public GroupMembershipDefinition setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public GroupMembershipDefinition setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public GroupMembershipDefinition setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public GroupMembershipDefinition setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public GroupMembershipDefinition setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public GroupMembershipDefinition setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public GroupMembershipDefinition setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public GroupMemberType getGroupMemberType() {
	    return getEnumValue(groupMemberType, GroupMemberType.values());
	}

	@Override
	public GroupMembershipDefinition setGroupMemberType(GroupMemberType value) {
    	setEnumValue(this.groupMemberType, value);
		return this;
	}

	@Override
	public User getUser() {
		if (isChanged(user)) {
			return (User) getReferenceChangeValue(user);
		} else {
			int id = user.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public GroupMembershipDefinition setUser(User value) {
		setSingleReferenceValue(user, value, table);
		return this;
	}

	@Override
	public Group getGroup() {
		if (isChanged(group)) {
			return (Group) getReferenceChangeValue(group);
		} else {
			int id = group.getValue(getId());
			if (id > 0) {
				return Group.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public GroupMembershipDefinition setGroup(Group value) {
		setSingleReferenceValue(group, value, table);
		return this;
	}

	@Override
	public Role getRole() {
		if (isChanged(role)) {
			return (Role) getReferenceChangeValue(role);
		} else {
			int id = role.getValue(getId());
			if (id > 0) {
				return Role.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public GroupMembershipDefinition setRole(Role value) {
		setSingleReferenceValue(role, value, table);
		return this;
	}

	@Override
	public OrganizationUnit getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnit) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public GroupMembershipDefinition setOrganizationUnit(OrganizationUnit value) {
		setSingleReferenceValue(organizationUnit, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnitType> getOrganizationUnitTypesFilter() {
	    return getMultiReferenceValue(organizationUnitTypesFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public GroupMembershipDefinition setOrganizationUnitTypesFilter(List<OrganizationUnitType> value) {
		setMultiReferenceValue(value, organizationUnitTypesFilter);
		return this;
	}

	@Override
	public int getOrganizationUnitTypesFilterCount() {
	    return getMultiReferenceValueCount(organizationUnitTypesFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public GroupMembershipDefinition setOrganizationUnitTypesFilter(OrganizationUnitType ... value) {
		setMultiReferenceValue(Arrays.asList(value), organizationUnitTypesFilter);
		return this;
	}

	@Override
	public BitSet getOrganizationUnitTypesFilterAsBitSet() {
	    return getMultiReferenceValueAsBitSet(organizationUnitTypesFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public GroupMembershipDefinition addOrganizationUnitTypesFilter(List<OrganizationUnitType> value) {
		addMultiReferenceValue(value, organizationUnitTypesFilter);
		return this;
	}

	@Override
	public GroupMembershipDefinition addOrganizationUnitTypesFilter(OrganizationUnitType ... value) {
		addMultiReferenceValue(Arrays.asList(value), organizationUnitTypesFilter);
		return this;
	}

	@Override
	public GroupMembershipDefinition removeOrganizationUnitTypesFilter(List<OrganizationUnitType> value) {
		removeMultiReferenceValue(value, organizationUnitTypesFilter);
		return this;
	}

	@Override
	public GroupMembershipDefinition removeOrganizationUnitTypesFilter(OrganizationUnitType ... value) {
		removeMultiReferenceValue(Arrays.asList(value), organizationUnitTypesFilter);
		return this;
	}

	@Override
	public GroupMembershipDefinition removeAllOrganizationUnitTypesFilter() {
		removeAllMultiReferenceValue(organizationUnitTypesFilter);
		return this;
	}


    @Override
    public UdbGroupMembershipDefinition save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbGroupMembershipDefinition saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbGroupMembershipDefinition save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



