package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbGroupQuery extends AbstractUdbQuery<Group> implements GroupQuery {

    public UdbGroupQuery() {
        super(UdbGroup.table, Group.getBuilder());
    }

	@Override
	public GroupQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbGroup.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public GroupQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbGroup.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public GroupQuery metaCreationDate(NumericFilter filter) {
		and(UdbGroup.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbGroup.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery metaCreatedBy(NumericFilter filter) {
		and(UdbGroup.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbGroup.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery metaModificationDate(NumericFilter filter) {
		and(UdbGroup.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbGroup.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery metaModifiedBy(NumericFilter filter) {
		and(UdbGroup.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbGroup.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery metaDeletionDate(NumericFilter filter) {
		and(UdbGroup.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbGroup.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery metaDeletedBy(NumericFilter filter) {
		and(UdbGroup.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbGroup.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery metaRestoreDate(NumericFilter filter) {
		and(UdbGroup.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbGroup.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery metaRestoredBy(NumericFilter filter) {
		and(UdbGroup.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbGroup.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery groupType(EnumFilterType filterType, GroupType... enums) {
		and(UdbGroup.groupType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public GroupQuery orGroupType(EnumFilterType filterType, GroupType... enums) {
		or(UdbGroup.groupType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public GroupQuery name(TextFilter filter) {
		and(UdbGroup.name.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orName(TextFilter filter) {
		or(UdbGroup.name.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery description(TextFilter filter) {
		and(UdbGroup.description.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orDescription(TextFilter filter) {
		or(UdbGroup.description.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery language(TextFilter filter) {
		and(UdbGroup.language.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orLanguage(TextFilter filter) {
		or(UdbGroup.language.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterOrganizationField(OrganizationFieldQuery query) {
		UdbOrganizationFieldQuery udbQuery = (UdbOrganizationFieldQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.organizationField);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery organizationField(NumericFilter filter) {
		and(UdbGroup.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orOrganizationField(NumericFilter filter) {
		or(UdbGroup.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterOrganizationUnit(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.organizationUnit);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery organizationUnit(NumericFilter filter) {
		and(UdbGroup.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orOrganizationUnit(NumericFilter filter) {
		or(UdbGroup.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterOwner(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.owner);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery owner(NumericFilter filter) {
		and(UdbGroup.owner.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orOwner(NumericFilter filter) {
		or(UdbGroup.owner.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterModerators(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.moderators);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery moderators(MultiReferenceFilterType type, User ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (User value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroup.moderators.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery moderatorsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroup.moderators.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery moderators(MultiReferenceFilter filter) {
		and(UdbGroup.moderators.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orModerators(MultiReferenceFilter filter) {
		or(UdbGroup.moderators.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterMentors(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.mentors);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery mentors(MultiReferenceFilterType type, User ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (User value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroup.mentors.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery mentorsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroup.mentors.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery mentors(MultiReferenceFilter filter) {
		and(UdbGroup.mentors.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMentors(MultiReferenceFilter filter) {
		or(UdbGroup.mentors.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery valid(BooleanFilter filter) {
		and(UdbGroup.valid.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orValid(BooleanFilter filter) {
		or(UdbGroup.valid.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterMembershipDefinitions(GroupMembershipDefinitionQuery query) {
		UdbGroupMembershipDefinitionQuery udbQuery = (UdbGroupMembershipDefinitionQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.membershipDefinitions, UdbGroupMembershipDefinition.group);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery membershipDefinitions(MultiReferenceFilterType type, GroupMembershipDefinition ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (GroupMembershipDefinition value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroup.membershipDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery membershipDefinitionsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroup.membershipDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery membershipDefinitions(MultiReferenceFilter filter) {
		and(UdbGroup.membershipDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orMembershipDefinitions(MultiReferenceFilter filter) {
		or(UdbGroup.membershipDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterRegistrationAllowedForDefinitions(GroupMembershipDefinitionQuery query) {
		UdbGroupMembershipDefinitionQuery udbQuery = (UdbGroupMembershipDefinitionQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.registrationAllowedForDefinitions);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery registrationAllowedForDefinitions(MultiReferenceFilterType type, GroupMembershipDefinition ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (GroupMembershipDefinition value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroup.registrationAllowedForDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery registrationAllowedForDefinitionsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroup.registrationAllowedForDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery registrationAllowedForDefinitions(MultiReferenceFilter filter) {
		and(UdbGroup.registrationAllowedForDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orRegistrationAllowedForDefinitions(MultiReferenceFilter filter) {
		or(UdbGroup.registrationAllowedForDefinitions.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterUserMemberships(UserGroupMembershipQuery query) {
		UdbUserGroupMembershipQuery udbQuery = (UdbUserGroupMembershipQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.userMemberships, UdbUserGroupMembership.group);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery userMemberships(MultiReferenceFilterType type, UserGroupMembership ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (UserGroupMembership value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroup.userMemberships.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery userMembershipsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroup.userMemberships.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery userMemberships(MultiReferenceFilter filter) {
		and(UdbGroup.userMemberships.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orUserMemberships(MultiReferenceFilter filter) {
		or(UdbGroup.userMemberships.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery lastMessageDate(NumericFilter filter) {
		and(UdbGroup.lastMessageDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orLastMessageDate(NumericFilter filter) {
		or(UdbGroup.lastMessageDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery filterGroupFolders(GroupFolderQuery query) {
		UdbGroupFolderQuery udbQuery = (UdbGroupFolderQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroup.groupFolders, UdbGroupFolder.group);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupQuery groupFolders(MultiReferenceFilterType type, GroupFolder ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (GroupFolder value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroup.groupFolders.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery groupFoldersCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroup.groupFolders.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery groupFolders(MultiReferenceFilter filter) {
		and(UdbGroup.groupFolders.createFilter(filter));
		return this;
	}

	@Override
	public GroupQuery orGroupFolders(MultiReferenceFilter filter) {
		or(UdbGroup.groupFolders.createFilter(filter));
		return this;
	}


	@Override
	public UdbGroupQuery andOr(GroupQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public GroupQuery customFilter(Function<Group, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Group.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



