package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbManagedApplicationQuery extends AbstractUdbQuery<ManagedApplication> implements ManagedApplicationQuery {

    public UdbManagedApplicationQuery() {
        super(UdbManagedApplication.table, ManagedApplication.getBuilder());
    }

	@Override
	public ManagedApplicationQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbManagedApplication.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ManagedApplicationQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbManagedApplication.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaCreationDate(NumericFilter filter) {
		and(UdbManagedApplication.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbManagedApplication.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaCreatedBy(NumericFilter filter) {
		and(UdbManagedApplication.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbManagedApplication.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaModificationDate(NumericFilter filter) {
		and(UdbManagedApplication.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbManagedApplication.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaModifiedBy(NumericFilter filter) {
		and(UdbManagedApplication.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbManagedApplication.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaDeletionDate(NumericFilter filter) {
		and(UdbManagedApplication.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbManagedApplication.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaDeletedBy(NumericFilter filter) {
		and(UdbManagedApplication.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbManagedApplication.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaRestoreDate(NumericFilter filter) {
		and(UdbManagedApplication.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbManagedApplication.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery metaRestoredBy(NumericFilter filter) {
		and(UdbManagedApplication.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbManagedApplication.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery filterMainApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbManagedApplication.mainApplication, UdbApplication.installedAsMainApplication);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ManagedApplicationQuery mainApplication(NumericFilter filter) {
		and(UdbManagedApplication.mainApplication.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orMainApplication(NumericFilter filter) {
		or(UdbManagedApplication.mainApplication.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery filterOrganizationField(OrganizationFieldQuery query) {
		UdbOrganizationFieldQuery udbQuery = (UdbOrganizationFieldQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbManagedApplication.organizationField);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ManagedApplicationQuery organizationField(NumericFilter filter) {
		and(UdbManagedApplication.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orOrganizationField(NumericFilter filter) {
		or(UdbManagedApplication.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery icon(TextFilter filter) {
		and(UdbManagedApplication.icon.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orIcon(TextFilter filter) {
		or(UdbManagedApplication.icon.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery titleKey(TextFilter filter) {
		and(UdbManagedApplication.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orTitleKey(TextFilter filter) {
		or(UdbManagedApplication.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery descriptionKey(TextFilter filter) {
		and(UdbManagedApplication.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orDescriptionKey(TextFilter filter) {
		or(UdbManagedApplication.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery singleApplication(BooleanFilter filter) {
		and(UdbManagedApplication.singleApplication.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orSingleApplication(BooleanFilter filter) {
		or(UdbManagedApplication.singleApplication.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery darkTheme(BooleanFilter filter) {
		and(UdbManagedApplication.darkTheme.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orDarkTheme(BooleanFilter filter) {
		or(UdbManagedApplication.darkTheme.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery startOnLogin(BooleanFilter filter) {
		and(UdbManagedApplication.startOnLogin.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orStartOnLogin(BooleanFilter filter) {
		or(UdbManagedApplication.startOnLogin.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery filterPerspectives(ManagedApplicationPerspectiveQuery query) {
		UdbManagedApplicationPerspectiveQuery udbQuery = (UdbManagedApplicationPerspectiveQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbManagedApplication.perspectives, UdbManagedApplicationPerspective.managedApplication);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ManagedApplicationQuery perspectives(MultiReferenceFilterType type, ManagedApplicationPerspective ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ManagedApplicationPerspective value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbManagedApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery perspectivesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbManagedApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery perspectives(MultiReferenceFilter filter) {
		and(UdbManagedApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orPerspectives(MultiReferenceFilter filter) {
		or(UdbManagedApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery listingPosition(NumericFilter filter) {
		and(UdbManagedApplication.listingPosition.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orListingPosition(NumericFilter filter) {
		or(UdbManagedApplication.listingPosition.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery toolbarApplicationMenu(BooleanFilter filter) {
		and(UdbManagedApplication.toolbarApplicationMenu.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orToolbarApplicationMenu(BooleanFilter filter) {
		or(UdbManagedApplication.toolbarApplicationMenu.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery filterApplicationGroup(ManagedApplicationGroupQuery query) {
		UdbManagedApplicationGroupQuery udbQuery = (UdbManagedApplicationGroupQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbManagedApplication.applicationGroup, UdbManagedApplicationGroup.applications);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ManagedApplicationQuery applicationGroup(NumericFilter filter) {
		and(UdbManagedApplication.applicationGroup.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orApplicationGroup(NumericFilter filter) {
		or(UdbManagedApplication.applicationGroup.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery hidden(BooleanFilter filter) {
		and(UdbManagedApplication.hidden.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationQuery orHidden(BooleanFilter filter) {
		or(UdbManagedApplication.hidden.createFilter(filter));
		return this;
	}


	@Override
	public UdbManagedApplicationQuery andOr(ManagedApplicationQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ManagedApplicationQuery customFilter(Function<ManagedApplication, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ManagedApplication.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



