package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbRoleApplicationRoleAssignment extends AbstractUdbEntity<RoleApplicationRoleAssignment> implements RoleApplicationRoleAssignment {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex role;
	protected static SingleReferenceIndex application;
	protected static TextIndex applicationRoleName;
	protected static SingleReferenceIndex organizationFieldFilter;
	protected static SingleReferenceIndex fixedOrganizationRoot;
	protected static MultiReferenceIndex organizationUnitTypeFilter;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		role = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ROLE);
		application = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION);
		applicationRoleName = (TextIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_ROLE_NAME);
		organizationFieldFilter = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_FIELD_FILTER);
		fixedOrganizationRoot = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_FIXED_ORGANIZATION_ROOT);
		organizationUnitTypeFilter = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT_TYPE_FILTER);
    }

    public static List<RoleApplicationRoleAssignment> getAll() {
        return new EntityBitSetList<>(RoleApplicationRoleAssignment.getBuilder(), table.getRecordBitSet());
    }

    public static List<RoleApplicationRoleAssignment> getDeletedRecords() {
        return new EntityBitSetList<>(RoleApplicationRoleAssignment.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<RoleApplicationRoleAssignment> sort(List<RoleApplicationRoleAssignment> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<RoleApplicationRoleAssignment> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, RoleApplicationRoleAssignment.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbRoleApplicationRoleAssignment() {
        super(table);
    }

    public UdbRoleApplicationRoleAssignment(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public RoleApplicationRoleAssignment build() {
        return new UdbRoleApplicationRoleAssignment();
    }

    @Override
    public RoleApplicationRoleAssignment build(int id) {
        return new UdbRoleApplicationRoleAssignment(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public RoleApplicationRoleAssignment setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public Role getRole() {
		if (isChanged(role)) {
			return (Role) getReferenceChangeValue(role);
		} else {
			int id = role.getValue(getId());
			if (id > 0) {
				return Role.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RoleApplicationRoleAssignment setRole(Role value) {
		setSingleReferenceValue(role, value, table);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RoleApplicationRoleAssignment setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public String getApplicationRoleName() {
        return getTextValue(applicationRoleName);
	}

	@Override
	public RoleApplicationRoleAssignment setApplicationRoleName(String value) {
	    setTextValue(value, this.applicationRoleName);
		return this;
	}

	@Override
	public OrganizationField getOrganizationFieldFilter() {
		if (isChanged(organizationFieldFilter)) {
			return (OrganizationField) getReferenceChangeValue(organizationFieldFilter);
		} else {
			int id = organizationFieldFilter.getValue(getId());
			if (id > 0) {
				return OrganizationField.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RoleApplicationRoleAssignment setOrganizationFieldFilter(OrganizationField value) {
		setSingleReferenceValue(organizationFieldFilter, value, table);
		return this;
	}

	@Override
	public OrganizationUnit getFixedOrganizationRoot() {
		if (isChanged(fixedOrganizationRoot)) {
			return (OrganizationUnit) getReferenceChangeValue(fixedOrganizationRoot);
		} else {
			int id = fixedOrganizationRoot.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RoleApplicationRoleAssignment setFixedOrganizationRoot(OrganizationUnit value) {
		setSingleReferenceValue(fixedOrganizationRoot, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnitType> getOrganizationUnitTypeFilter() {
	    return getMultiReferenceValue(organizationUnitTypeFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public RoleApplicationRoleAssignment setOrganizationUnitTypeFilter(List<OrganizationUnitType> value) {
		setMultiReferenceValue(value, organizationUnitTypeFilter);
		return this;
	}

	@Override
	public int getOrganizationUnitTypeFilterCount() {
	    return getMultiReferenceValueCount(organizationUnitTypeFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public RoleApplicationRoleAssignment setOrganizationUnitTypeFilter(OrganizationUnitType ... value) {
		setMultiReferenceValue(Arrays.asList(value), organizationUnitTypeFilter);
		return this;
	}

	@Override
	public BitSet getOrganizationUnitTypeFilterAsBitSet() {
	    return getMultiReferenceValueAsBitSet(organizationUnitTypeFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public RoleApplicationRoleAssignment addOrganizationUnitTypeFilter(List<OrganizationUnitType> value) {
		addMultiReferenceValue(value, organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignment addOrganizationUnitTypeFilter(OrganizationUnitType ... value) {
		addMultiReferenceValue(Arrays.asList(value), organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignment removeOrganizationUnitTypeFilter(List<OrganizationUnitType> value) {
		removeMultiReferenceValue(value, organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignment removeOrganizationUnitTypeFilter(OrganizationUnitType ... value) {
		removeMultiReferenceValue(Arrays.asList(value), organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignment removeAllOrganizationUnitTypeFilter() {
		removeAllMultiReferenceValue(organizationUnitTypeFilter);
		return this;
	}


    @Override
    public UdbRoleApplicationRoleAssignment save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbRoleApplicationRoleAssignment saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbRoleApplicationRoleAssignment save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



