package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbRolePrivilegeAssignmentQuery extends AbstractUdbQuery<RolePrivilegeAssignment> implements RolePrivilegeAssignmentQuery {

    public UdbRolePrivilegeAssignmentQuery() {
        super(UdbRolePrivilegeAssignment.table, RolePrivilegeAssignment.getBuilder());
    }

	@Override
	public RolePrivilegeAssignmentQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbRolePrivilegeAssignment.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbRolePrivilegeAssignment.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaCreationDate(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaCreatedBy(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaModificationDate(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaModifiedBy(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaDeletionDate(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaDeletedBy(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaRestoreDate(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery metaRestoredBy(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery filterRole(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRolePrivilegeAssignment.role, UdbRole.privilegeAssignments);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery role(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.role.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orRole(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.role.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRolePrivilegeAssignment.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery application(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.application.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orApplication(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.application.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery filterPrivilegeGroup(ApplicationPrivilegeGroupQuery query) {
		UdbApplicationPrivilegeGroupQuery udbQuery = (UdbApplicationPrivilegeGroupQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRolePrivilegeAssignment.privilegeGroup);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery privilegeGroup(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.privilegeGroup.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orPrivilegeGroup(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.privilegeGroup.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery filterPrivileges(ApplicationPrivilegeQuery query) {
		UdbApplicationPrivilegeQuery udbQuery = (UdbApplicationPrivilegeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRolePrivilegeAssignment.privileges);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery privileges(MultiReferenceFilterType type, ApplicationPrivilege ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ApplicationPrivilege value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRolePrivilegeAssignment.privileges.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery privilegesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRolePrivilegeAssignment.privileges.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery privileges(MultiReferenceFilter filter) {
		and(UdbRolePrivilegeAssignment.privileges.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orPrivileges(MultiReferenceFilter filter) {
		or(UdbRolePrivilegeAssignment.privileges.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery privilegeObjects(TextFilter filter) {
		and(UdbRolePrivilegeAssignment.privilegeObjects.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orPrivilegeObjects(TextFilter filter) {
		or(UdbRolePrivilegeAssignment.privilegeObjects.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery privilegeObjectInheritance(BooleanFilter filter) {
		and(UdbRolePrivilegeAssignment.privilegeObjectInheritance.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orPrivilegeObjectInheritance(BooleanFilter filter) {
		or(UdbRolePrivilegeAssignment.privilegeObjectInheritance.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery filterOrganizationFieldFilter(OrganizationFieldQuery query) {
		UdbOrganizationFieldQuery udbQuery = (UdbOrganizationFieldQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRolePrivilegeAssignment.organizationFieldFilter);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery organizationFieldFilter(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.organizationFieldFilter.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orOrganizationFieldFilter(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.organizationFieldFilter.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery filterFixedOrganizationRoot(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRolePrivilegeAssignment.fixedOrganizationRoot);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery fixedOrganizationRoot(NumericFilter filter) {
		and(UdbRolePrivilegeAssignment.fixedOrganizationRoot.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orFixedOrganizationRoot(NumericFilter filter) {
		or(UdbRolePrivilegeAssignment.fixedOrganizationRoot.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery filterOrganizationUnitTypeFilter(OrganizationUnitTypeQuery query) {
		UdbOrganizationUnitTypeQuery udbQuery = (UdbOrganizationUnitTypeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRolePrivilegeAssignment.organizationUnitTypeFilter);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery organizationUnitTypeFilter(MultiReferenceFilterType type, OrganizationUnitType ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitType value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRolePrivilegeAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery organizationUnitTypeFilterCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRolePrivilegeAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery organizationUnitTypeFilter(MultiReferenceFilter filter) {
		and(UdbRolePrivilegeAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}

	@Override
	public RolePrivilegeAssignmentQuery orOrganizationUnitTypeFilter(MultiReferenceFilter filter) {
		or(UdbRolePrivilegeAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}


	@Override
	public UdbRolePrivilegeAssignmentQuery andOr(RolePrivilegeAssignmentQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public RolePrivilegeAssignmentQuery customFilter(Function<RolePrivilegeAssignment, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(RolePrivilegeAssignment.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



