package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbRoleQuery extends AbstractUdbQuery<Role> implements RoleQuery {

    public UdbRoleQuery() {
        super(UdbRole.table, Role.getBuilder());
    }

	@Override
	public RoleQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbRole.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public RoleQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbRole.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public RoleQuery metaCreationDate(NumericFilter filter) {
		and(UdbRole.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbRole.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery metaCreatedBy(NumericFilter filter) {
		and(UdbRole.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbRole.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery metaModificationDate(NumericFilter filter) {
		and(UdbRole.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbRole.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery metaModifiedBy(NumericFilter filter) {
		and(UdbRole.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbRole.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery metaDeletionDate(NumericFilter filter) {
		and(UdbRole.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbRole.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery metaDeletedBy(NumericFilter filter) {
		and(UdbRole.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbRole.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery metaRestoreDate(NumericFilter filter) {
		and(UdbRole.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbRole.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery metaRestoredBy(NumericFilter filter) {
		and(UdbRole.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbRole.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery title(TranslatableTextFilter filter) {
		and(UdbRole.title.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orTitle(TranslatableTextFilter filter) {
		or(UdbRole.title.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery icon(TextFilter filter) {
		and(UdbRole.icon.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orIcon(TextFilter filter) {
		or(UdbRole.icon.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterParent(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.parent, UdbRole.children);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery parent(NumericFilter filter) {
		and(UdbRole.parent.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orParent(NumericFilter filter) {
		or(UdbRole.parent.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterChildren(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.children, UdbRole.parent);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery children(MultiReferenceFilterType type, Role ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Role value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.children.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery childrenCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.children.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery children(MultiReferenceFilter filter) {
		and(UdbRole.children.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orChildren(MultiReferenceFilter filter) {
		or(UdbRole.children.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterAllowedOrganizationUnitTypes(OrganizationUnitTypeQuery query) {
		UdbOrganizationUnitTypeQuery udbQuery = (UdbOrganizationUnitTypeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.allowedOrganizationUnitTypes);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery allowedOrganizationUnitTypes(MultiReferenceFilterType type, OrganizationUnitType ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitType value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.allowedOrganizationUnitTypes.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery allowedOrganizationUnitTypesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.allowedOrganizationUnitTypes.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery allowedOrganizationUnitTypes(MultiReferenceFilter filter) {
		and(UdbRole.allowedOrganizationUnitTypes.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orAllowedOrganizationUnitTypes(MultiReferenceFilter filter) {
		or(UdbRole.allowedOrganizationUnitTypes.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterOrganizationField(OrganizationFieldQuery query) {
		UdbOrganizationFieldQuery udbQuery = (UdbOrganizationFieldQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.organizationField);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery organizationField(NumericFilter filter) {
		and(UdbRole.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orOrganizationField(NumericFilter filter) {
		or(UdbRole.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterGeneralizationRoles(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.generalizationRoles, UdbRole.specializationRoles);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery generalizationRoles(MultiReferenceFilterType type, Role ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Role value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.generalizationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery generalizationRolesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.generalizationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery generalizationRoles(MultiReferenceFilter filter) {
		and(UdbRole.generalizationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orGeneralizationRoles(MultiReferenceFilter filter) {
		or(UdbRole.generalizationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterSpecializationRoles(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.specializationRoles, UdbRole.generalizationRoles);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery specializationRoles(MultiReferenceFilterType type, Role ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Role value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.specializationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery specializationRolesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.specializationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery specializationRoles(MultiReferenceFilter filter) {
		and(UdbRole.specializationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orSpecializationRoles(MultiReferenceFilter filter) {
		or(UdbRole.specializationRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterPrivilegesReceivingRoles(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.privilegesReceivingRoles, UdbRole.privilegesSendingRoles);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery privilegesReceivingRoles(MultiReferenceFilterType type, Role ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Role value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.privilegesReceivingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery privilegesReceivingRolesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.privilegesReceivingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery privilegesReceivingRoles(MultiReferenceFilter filter) {
		and(UdbRole.privilegesReceivingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orPrivilegesReceivingRoles(MultiReferenceFilter filter) {
		or(UdbRole.privilegesReceivingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterPrivilegesSendingRoles(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.privilegesSendingRoles, UdbRole.privilegesReceivingRoles);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery privilegesSendingRoles(MultiReferenceFilterType type, Role ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Role value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.privilegesSendingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery privilegesSendingRolesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.privilegesSendingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery privilegesSendingRoles(MultiReferenceFilter filter) {
		and(UdbRole.privilegesSendingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orPrivilegesSendingRoles(MultiReferenceFilter filter) {
		or(UdbRole.privilegesSendingRoles.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery noDirectMemberships(BooleanFilter filter) {
		and(UdbRole.noDirectMemberships.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orNoDirectMemberships(BooleanFilter filter) {
		or(UdbRole.noDirectMemberships.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterUserRoleAssignments(UserRoleAssignmentQuery query) {
		UdbUserRoleAssignmentQuery udbQuery = (UdbUserRoleAssignmentQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.userRoleAssignments, UdbUserRoleAssignment.role);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery userRoleAssignments(MultiReferenceFilterType type, UserRoleAssignment ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (UserRoleAssignment value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.userRoleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery userRoleAssignmentsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.userRoleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery userRoleAssignments(MultiReferenceFilter filter) {
		and(UdbRole.userRoleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orUserRoleAssignments(MultiReferenceFilter filter) {
		or(UdbRole.userRoleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterPrivilegeAssignments(RolePrivilegeAssignmentQuery query) {
		UdbRolePrivilegeAssignmentQuery udbQuery = (UdbRolePrivilegeAssignmentQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.privilegeAssignments, UdbRolePrivilegeAssignment.role);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery privilegeAssignments(MultiReferenceFilterType type, RolePrivilegeAssignment ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (RolePrivilegeAssignment value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.privilegeAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery privilegeAssignmentsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.privilegeAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery privilegeAssignments(MultiReferenceFilter filter) {
		and(UdbRole.privilegeAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orPrivilegeAssignments(MultiReferenceFilter filter) {
		or(UdbRole.privilegeAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery filterApplicationRoleAssignments(RoleApplicationRoleAssignmentQuery query) {
		UdbRoleApplicationRoleAssignmentQuery udbQuery = (UdbRoleApplicationRoleAssignmentQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRole.applicationRoleAssignments, UdbRoleApplicationRoleAssignment.role);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleQuery applicationRoleAssignments(MultiReferenceFilterType type, RoleApplicationRoleAssignment ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (RoleApplicationRoleAssignment value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRole.applicationRoleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery applicationRoleAssignmentsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRole.applicationRoleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery applicationRoleAssignments(MultiReferenceFilter filter) {
		and(UdbRole.applicationRoleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public RoleQuery orApplicationRoleAssignments(MultiReferenceFilter filter) {
		or(UdbRole.applicationRoleAssignments.createFilter(filter));
		return this;
	}


	@Override
	public UdbRoleQuery andOr(RoleQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public RoleQuery customFilter(Function<Role, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Role.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



