package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserAcceptedPolicy extends AbstractUdbEntity<UserAcceptedPolicy> implements UserAcceptedPolicy {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static IntegerIndex lastAcceptedPrivacyPolicy;
	protected static IntegerIndex lastAcceptedTermsOfUse;
	protected static MultiReferenceIndex acceptEntries;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		lastAcceptedPrivacyPolicy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_LAST_ACCEPTED_PRIVACY_POLICY);
		lastAcceptedTermsOfUse = (IntegerIndex) tableIndex.getColumnIndex(FIELD_LAST_ACCEPTED_TERMS_OF_USE);
		acceptEntries = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ACCEPT_ENTRIES);
    }

    public static List<UserAcceptedPolicy> getAll() {
        return new EntityBitSetList<>(UserAcceptedPolicy.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserAcceptedPolicy> getDeletedRecords() {
        return new EntityBitSetList<>(UserAcceptedPolicy.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<UserAcceptedPolicy> sort(List<UserAcceptedPolicy> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<UserAcceptedPolicy> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, UserAcceptedPolicy.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserAcceptedPolicy() {
        super(table);
    }

    public UdbUserAcceptedPolicy(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserAcceptedPolicy build() {
        return new UdbUserAcceptedPolicy();
    }

    @Override
    public UserAcceptedPolicy build(int id) {
        return new UdbUserAcceptedPolicy(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public UserAcceptedPolicy setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public UserAcceptedPolicy setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public UserAcceptedPolicy setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public UserAcceptedPolicy setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public UserAcceptedPolicy setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public UserAcceptedPolicy setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public UserAcceptedPolicy setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public UserAcceptedPolicy setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public UserAcceptedPolicy setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public UserAcceptedPolicy setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public UserAcceptedPolicy setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public UserAcceptedPolicy setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public UserAcceptedPolicy setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public UserAcceptedPolicy setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public UserAcceptedPolicy setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public UserAcceptedPolicy setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public int getLastAcceptedPrivacyPolicy() {
        return getIntValue(lastAcceptedPrivacyPolicy);
	}

	@Override
	public UserAcceptedPolicy setLastAcceptedPrivacyPolicy(int value) {
	    setIntValue(value, this.lastAcceptedPrivacyPolicy);
		return this;
	}

	@Override
	public int getLastAcceptedTermsOfUse() {
        return getIntValue(lastAcceptedTermsOfUse);
	}

	@Override
	public UserAcceptedPolicy setLastAcceptedTermsOfUse(int value) {
	    setIntValue(value, this.lastAcceptedTermsOfUse);
		return this;
	}

	@Override
	public List<UserAcceptedPolicyEntries> getAcceptEntries() {
	    return getMultiReferenceValue(acceptEntries, UserAcceptedPolicyEntries.getBuilder());
	}

	@Override
	public UserAcceptedPolicy setAcceptEntries(List<UserAcceptedPolicyEntries> value) {
		setMultiReferenceValue(value, acceptEntries);
		return this;
	}

	@Override
	public int getAcceptEntriesCount() {
	    return getMultiReferenceValueCount(acceptEntries, UserAcceptedPolicyEntries.getBuilder());
	}

	@Override
	public UserAcceptedPolicy setAcceptEntries(UserAcceptedPolicyEntries ... value) {
		setMultiReferenceValue(Arrays.asList(value), acceptEntries);
		return this;
	}

	@Override
	public BitSet getAcceptEntriesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(acceptEntries, UserAcceptedPolicyEntries.getBuilder());
	}

	@Override
	public UserAcceptedPolicy addAcceptEntries(List<UserAcceptedPolicyEntries> value) {
		addMultiReferenceValue(value, acceptEntries);
		return this;
	}

	@Override
	public UserAcceptedPolicy addAcceptEntries(UserAcceptedPolicyEntries ... value) {
		addMultiReferenceValue(Arrays.asList(value), acceptEntries);
		return this;
	}

	@Override
	public UserAcceptedPolicy removeAcceptEntries(List<UserAcceptedPolicyEntries> value) {
		removeMultiReferenceValue(value, acceptEntries);
		return this;
	}

	@Override
	public UserAcceptedPolicy removeAcceptEntries(UserAcceptedPolicyEntries ... value) {
		removeMultiReferenceValue(Arrays.asList(value), acceptEntries);
		return this;
	}

	@Override
	public UserAcceptedPolicy removeAllAcceptEntries() {
		removeAllMultiReferenceValue(acceptEntries);
		return this;
	}


    @Override
    public UdbUserAcceptedPolicy save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbUserAcceptedPolicy saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbUserAcceptedPolicy save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



