package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface UserAcceptedPolicyEntriesQuery extends Query<UserAcceptedPolicyEntries> {

    static UserAcceptedPolicyEntriesQuery create() {
        return new UdbUserAcceptedPolicyEntriesQuery();
    }

    UserAcceptedPolicyEntriesQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserAcceptedPolicyEntriesQuery parseFullTextFilter(String query, String... fieldNames);

	UserAcceptedPolicyEntriesQuery metaCreationDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaCreationDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery metaCreatedBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaCreatedBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery metaModificationDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaModificationDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery metaModifiedBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaModifiedBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery metaDeletionDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaDeletionDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery metaDeletedBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaDeletedBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery metaRestoreDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaRestoreDate(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery metaRestoredBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orMetaRestoredBy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery acceptedPrivacyPolicy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orAcceptedPrivacyPolicy(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery acceptedTermsOfUse(NumericFilter filter);

	UserAcceptedPolicyEntriesQuery orAcceptedTermsOfUse(NumericFilter filter);


    UserAcceptedPolicyEntriesQuery andOr(UserAcceptedPolicyEntriesQuery... queries);

    UserAcceptedPolicyEntriesQuery customFilter(Function<UserAcceptedPolicyEntries, Boolean> customFilter);

    List<UserAcceptedPolicyEntries> execute();

    List<UserAcceptedPolicyEntries> executeOnDeletedRecords();

    UserAcceptedPolicyEntries executeExpectSingleton();

    BitSet executeToBitSet();

    List<UserAcceptedPolicyEntries> execute(String sortFieldName, boolean ascending, String ... path);

    List<UserAcceptedPolicyEntries> execute(int startIndex, int length, Sorting sorting);

}

