package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface UserAcceptedPolicyQuery extends Query<UserAcceptedPolicy> {

    static UserAcceptedPolicyQuery create() {
        return new UdbUserAcceptedPolicyQuery();
    }

    UserAcceptedPolicyQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserAcceptedPolicyQuery parseFullTextFilter(String query, String... fieldNames);

	UserAcceptedPolicyQuery metaCreationDate(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaCreationDate(NumericFilter filter);

	UserAcceptedPolicyQuery metaCreatedBy(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaCreatedBy(NumericFilter filter);

	UserAcceptedPolicyQuery metaModificationDate(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaModificationDate(NumericFilter filter);

	UserAcceptedPolicyQuery metaModifiedBy(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaModifiedBy(NumericFilter filter);

	UserAcceptedPolicyQuery metaDeletionDate(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaDeletionDate(NumericFilter filter);

	UserAcceptedPolicyQuery metaDeletedBy(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaDeletedBy(NumericFilter filter);

	UserAcceptedPolicyQuery metaRestoreDate(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaRestoreDate(NumericFilter filter);

	UserAcceptedPolicyQuery metaRestoredBy(NumericFilter filter);

	UserAcceptedPolicyQuery orMetaRestoredBy(NumericFilter filter);

	UserAcceptedPolicyQuery lastAcceptedPrivacyPolicy(NumericFilter filter);

	UserAcceptedPolicyQuery orLastAcceptedPrivacyPolicy(NumericFilter filter);

	UserAcceptedPolicyQuery lastAcceptedTermsOfUse(NumericFilter filter);

	UserAcceptedPolicyQuery orLastAcceptedTermsOfUse(NumericFilter filter);

	UserAcceptedPolicyQuery filterAcceptEntries(UserAcceptedPolicyEntriesQuery query);

	UserAcceptedPolicyQuery acceptEntries(MultiReferenceFilterType type, UserAcceptedPolicyEntries ... value);

	UserAcceptedPolicyQuery acceptEntriesCount(MultiReferenceFilterType type, int count);

	UserAcceptedPolicyQuery acceptEntries(MultiReferenceFilter filter);

	UserAcceptedPolicyQuery orAcceptEntries(MultiReferenceFilter filter);


    UserAcceptedPolicyQuery andOr(UserAcceptedPolicyQuery... queries);

    UserAcceptedPolicyQuery customFilter(Function<UserAcceptedPolicy, Boolean> customFilter);

    List<UserAcceptedPolicy> execute();

    List<UserAcceptedPolicy> executeOnDeletedRecords();

    UserAcceptedPolicy executeExpectSingleton();

    BitSet executeToBitSet();

    List<UserAcceptedPolicy> execute(String sortFieldName, boolean ascending, String ... path);

    List<UserAcceptedPolicy> execute(int startIndex, int length, Sorting sorting);

}

