package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserGroupMembership extends Entity<UserGroupMembership> {

	final static String FIELD_GROUP = "group";
	final static String FIELD_USER = "user";
	final static String FIELD_GROUP_MEMBERSHIP_ROLE = "groupMembershipRole";
	final static String FIELD_MEMBERSHIP_REJECTED = "membershipRejected";
	final static String FIELD_GROUP_MEMBERSHIP_NOTIFICATION_SETTING = "groupMembershipNotificationSetting";

    static UserGroupMembership create() {
        return new UdbUserGroupMembership();
    }

    static UserGroupMembership create(int id) {
        return new UdbUserGroupMembership(id, true);
    }

    static UserGroupMembership getById(int id) {
        return new UdbUserGroupMembership(id, false);
    }

    static EntityBuilder<UserGroupMembership> getBuilder() {
        return new UdbUserGroupMembership(0, false);
    }

    Group getGroup();

    UserGroupMembership setGroup(Group value);

    User getUser();

    UserGroupMembership setUser(User value);

    GroupMembershipRole getGroupMembershipRole();

    UserGroupMembership setGroupMembershipRole(GroupMembershipRole value);

    boolean getMembershipRejected();

    UserGroupMembership setMembershipRejected(boolean value);

    boolean isMembershipRejected();

    GroupMembershipNotificationSetting getGroupMembershipNotificationSetting();

    UserGroupMembership setGroupMembershipNotificationSetting(GroupMembershipNotificationSetting value);


    static List<UserGroupMembership> getAll() {
        return UdbUserGroupMembership.getAll();
    }

    static List<UserGroupMembership> getDeletedRecords() {
        return UdbUserGroupMembership.getDeletedRecords();
    }

    static List<UserGroupMembership> sort(List<UserGroupMembership> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbUserGroupMembership.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbUserGroupMembership.getCount();
    }

    static UserGroupMembershipQuery filter() {
        return new UdbUserGroupMembershipQuery();
    }
}

