package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface UserGroupMembershipQuery extends Query<UserGroupMembership> {

    static UserGroupMembershipQuery create() {
        return new UdbUserGroupMembershipQuery();
    }

    UserGroupMembershipQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserGroupMembershipQuery parseFullTextFilter(String query, String... fieldNames);

	UserGroupMembershipQuery filterGroup(GroupQuery query);

	UserGroupMembershipQuery group(NumericFilter filter);

	UserGroupMembershipQuery orGroup(NumericFilter filter);

	UserGroupMembershipQuery filterUser(UserQuery query);

	UserGroupMembershipQuery user(NumericFilter filter);

	UserGroupMembershipQuery orUser(NumericFilter filter);

	UserGroupMembershipQuery groupMembershipRole(EnumFilterType filterType, GroupMembershipRole ... enums);

	UserGroupMembershipQuery orGroupMembershipRole(EnumFilterType filterType, GroupMembershipRole ... enums);

	UserGroupMembershipQuery membershipRejected(BooleanFilter filter);

	UserGroupMembershipQuery orMembershipRejected(BooleanFilter filter);

	UserGroupMembershipQuery groupMembershipNotificationSetting(EnumFilterType filterType, GroupMembershipNotificationSetting ... enums);

	UserGroupMembershipQuery orGroupMembershipNotificationSetting(EnumFilterType filterType, GroupMembershipNotificationSetting ... enums);


    UserGroupMembershipQuery andOr(UserGroupMembershipQuery... queries);

    UserGroupMembershipQuery customFilter(Function<UserGroupMembership, Boolean> customFilter);

    List<UserGroupMembership> execute();

    List<UserGroupMembership> executeOnDeletedRecords();

    UserGroupMembership executeExpectSingleton();

    BitSet executeToBitSet();

    List<UserGroupMembership> execute(String sortFieldName, boolean ascending, String ... path);

    List<UserGroupMembership> execute(int startIndex, int length, Sorting sorting);

}

