/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.chat;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.ChatMessage;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.TimeGraph;

public class ChatPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();

    public ChatPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        View timeLineView = this.getPerspective().addView(View.createView((String)"top", (Icon)ApplicationIcons.FORM, (String)this.getLocalized("org.teamapps.dictionary.timeline"), null));
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.MESSAGES, (String)this.getLocalized("chat.title"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.MESSAGES, (String)this.getLocalized("chat.title"), null));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder userModelBuilder = new EntityModelBuilder(() -> ChatMessage.filter(), this.getApplicationInstanceData());
        TimeGraph timeGraph = userModelBuilder.createTimeGraph(ChatMessage::getMetaCreationDateAsEpochMilli, "metaCreationDate");
        userModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("chat.title"));
        userModelBuilder.attachSearchField(masterView);
        Table table = userModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(32);
        table.setStripedRows(false);
        userModelBuilder.updateModels();
        timeLineView.setComponent((Component)timeGraph);
        TemplateField userTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("chatChannel", "Channel", (AbstractField)new TextField()).setDefaultWidth(150));
        table.addColumn(new TableColumn("author", "Author", (AbstractField)userTableField).setDefaultWidth(180));
        table.addColumn(new TableColumn("metaCreationDate", "Date", (AbstractField)new InstantDateTimeField()).setDefaultWidth(200));
        table.addColumn(new TableColumn("message", "Message", (AbstractField)new TextField()).setDefaultWidth(350));
        table.setPropertyExtractor((message, propertyName) -> switch (propertyName) {
            case "chatChannel" -> message.getChatChannel().getTitle();
            case "author" -> message.getAuthor();
            case "metaCreationDate" -> message.getMetaCreationDate();
            case "message" -> message.getMessage();
            default -> null;
        });
        masterView.setComponent((Component)table);
        TextField channelTitle = new TextField();
        TemplateField author = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        InstantDateTimeField dateTimeField = new InstantDateTimeField();
        MultiLineTextField messageField = new MultiLineTextField();
        messageField.setCssStyle("height", Length.ofPixels((int)150).toCssString());
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, "Channel", (AbstractField)channelTitle);
        formLayout.addLabelAndField(null, "Author", (AbstractField)author);
        formLayout.addLabelAndField(null, "Date", (AbstractField)dateTimeField);
        formLayout.addLabelAndField(null, "Message", (AbstractField)messageField);
        FormMetaFields formMetaFields = this.getApplicationInstanceData().getComponentFactory().createFormMetaFields();
        formMetaFields.addMetaFields(formLayout, false);
        userModelBuilder.getOnSelectionEvent().addListener(arg_0 -> ((FormMetaFields)formMetaFields).updateEntity(arg_0));
        detailView.setComponent((Component)form);
        userModelBuilder.getOnSelectionEvent().addListener(message -> {
            channelTitle.setValue((Object)message.getChatChannel().getTitle());
            author.setValue((Object)message.getAuthor());
            dateTimeField.setValue((Object)message.getMetaCreationDate());
            messageField.setValue((Object)message.getMessage());
        });
    }
}

