/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.monitoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.config.MonitoringDashboardConfig;
import org.teamapps.application.server.system.config.MonitoringLink;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.iframe.IFrame;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;

public class MonitoringPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
    private final MonitoringDashboardConfig config = this.userSessionData.getRegistry().getSystemConfig().getServerMonitoringDashboardConfig();

    public MonitoringPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        Tree<MonitoringLink> perspectiveMenu = this.createPerspectiveMenu();
        this.setPerspectiveMenuPanel((Component)perspectiveMenu);
        View centerView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.CHART_LINE, (String)this.getLocalized("monitoring.title"), null));
        IFrame iFrame = new IFrame();
        centerView.setComponent((Component)iFrame);
        perspectiveMenu.onNodeSelected.addListener(node -> {
            centerView.setTitle(node.getTitle());
            iFrame.setUrl(node.getLink());
        });
        if (!this.config.getMonitoringLinks().isEmpty()) {
            iFrame.setUrl(this.config.getMonitoringLinks().get(0).getLink());
        }
    }

    private Tree<MonitoringLink> createPerspectiveMenu() {
        ArrayList<MonitoringLink> links = new ArrayList<MonitoringLink>();
        for (MonitoringLink monitoringLink2 : this.config.getMonitoringLinks()) {
            this.getAllLinks(monitoringLink2, links);
        }
        ListTreeModel treeModel = new ListTreeModel(links);
        treeModel.setTreeNodeInfoFunction(monitoringLink -> new TreeNodeInfo(){
            final /* synthetic */ MonitoringLink val$monitoringLink;
            {
                this.val$monitoringLink = monitoringLink;
            }

            public Object getParent() {
                return MonitoringPerspective.this.getParent(this.val$monitoringLink);
            }

            public boolean isExpanded() {
                return false;
            }

            public boolean isLazyChildren() {
                return false;
            }
        });
        Tree tree = new Tree((TreeModel)treeModel);
        tree.setPropertyProvider((monitoringLink, s) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", ApplicationIcons.CHART_LINE);
            map.put("caption", monitoringLink.getTitle());
            return map;
        });
        tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE);
        tree.setOpenOnSelection(true);
        tree.setEnforceSingleExpandedPath(true);
        return tree;
    }

    private void getAllLinks(MonitoringLink link, List<MonitoringLink> links) {
        links.add(link);
        for (MonitoringLink childLink : link.getChildLinks()) {
            this.getAllLinks(childLink, links);
        }
    }

    private MonitoringLink getParent(MonitoringLink link) {
        for (MonitoringLink monitoringLink : this.config.getMonitoringLinks()) {
            for (MonitoringLink childLink : monitoringLink.getChildLinks()) {
                MonitoringLink result = this.getParentFromChild(childLink, link, monitoringLink);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private MonitoringLink getParentFromChild(MonitoringLink child, MonitoringLink search, MonitoringLink parent) {
        if (search.equals(child)) {
            return parent;
        }
        for (MonitoringLink childLink : child.getChildLinks()) {
            MonitoringLink link = this.getParentFromChild(childLink, search, child);
            if (link == null) continue;
            return link;
        }
        return null;
    }
}

