/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.application;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.AbstractApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.databinding.MutableValue;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.OrganizationField;

public abstract class AbstractManagedApplicationPerspective
extends AbstractApplicationPerspective {
    private ManagedApplication managedApplication;
    private Application mainApplication;
    private OrganizationField organizationField;

    public AbstractManagedApplicationPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.init();
    }

    private void init() {
        this.managedApplication = ManagedApplication.getById(this.getApplicationInstanceData().getManagedApplicationId());
        this.mainApplication = this.managedApplication.getMainApplication();
        this.organizationField = OrganizationUtils.convert(this.getApplicationInstanceData().getOrganizationField());
    }

    public boolean isAppFilter() {
        return this.isOrgFieldFilterApplied() && this.getMainApplication() != null;
    }

    public boolean isOrgFieldFilterApplied() {
        return this.organizationField != null;
    }

    public ManagedApplication getManagedApplication() {
        return this.managedApplication;
    }

    public Application getMainApplication() {
        return this.mainApplication;
    }

    public OrganizationField getOrganizationField() {
        return this.organizationField;
    }
}

