/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.localization.DictionaryLocalizationProvider;
import org.teamapps.application.server.system.localization.SystemLocalizationProvider;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.universaldb.index.translation.TranslatableText;

public class GlobalLocalizationProvider {
    private final DictionaryLocalizationProvider dictionary;
    private final SystemLocalizationProvider systemDictionary;
    private Map<String, Map<String, LocalizationValue>> allKeysMap;
    private Map<Application, Map<String, Map<String, LocalizationValue>>> applicationLocalizationMap;

    public GlobalLocalizationProvider(SystemRegistry registry) {
        this.dictionary = registry.getDictionary();
        this.systemDictionary = registry.getSystemDictionary();
        this.updateLocalizationData();
    }

    public void updateLocalizationData() {
        try {
            HashMap<String, Map<String, LocalizationValue>> allKeysMap = new HashMap<String, Map<String, LocalizationValue>>();
            HashMap<Application, Map<String, Map<String, LocalizationValue>>> applicationLocalizationMap = new HashMap<Application, Map<String, Map<String, LocalizationValue>>>();
            LocalizationKey.filter().execute().stream().flatMap(key -> key.getLocalizationValues().stream()).forEach(value -> {
                allKeysMap.computeIfAbsent(value.getLocalizationKey().getKey(), k -> new HashMap()).put(value.getLanguage(), value);
                applicationLocalizationMap.computeIfAbsent(value.getLocalizationKey().getApplication(), k -> new HashMap()).computeIfAbsent(value.getLocalizationKey().getKey(), k -> new HashMap()).put(value.getLanguage(), value);
            });
            this.allKeysMap = allKeysMap;
            this.applicationLocalizationMap = applicationLocalizationMap;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String getLocalized(String key, Application application, List<String> rankedLanguages) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        if (key.startsWith("org.teamapps.dictionary.")) {
            return this.dictionary.getLocalizationValue(key, rankedLanguages);
        }
        if (key.startsWith("org.teamapps.systemKey.")) {
            return this.systemDictionary.getLocalizationValue(key, rankedLanguages);
        }
        if (application != null) {
            return this.getLocalizationValue(key, this.applicationLocalizationMap.get(application), rankedLanguages);
        }
        return this.getLocalizationValue(key, this.allKeysMap, rankedLanguages);
    }

    private String getLocalizationValue(String key, Map<String, Map<String, LocalizationValue>> localizationMap, List<String> rankedLanguages) {
        if (localizationMap == null) {
            return key;
        }
        Map<String, LocalizationValue> languageValueMap = localizationMap.get(key);
        if (languageValueMap != null) {
            for (String language : rankedLanguages) {
                LocalizationValue value = languageValueMap.get(language);
                if (value == null || value.getCurrentDisplayValue() == null) continue;
                return value.getCurrentDisplayValue();
            }
        }
        return key;
    }

    public String getLocalized(String key, Application application, List<String> rankedLanguage, Object ... parameters) {
        String localizationValue = this.getLocalized(key, application, rankedLanguage);
        if (parameters != null && parameters.length > 0) {
            try {
                return MessageFormat.format(localizationValue, parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                return localizationValue;
            }
        }
        return localizationValue;
    }

    public String getLocalized(TranslatableText translatableText, List<String> rankedLanguages) {
        if (translatableText == null) {
            return null;
        }
        Map translationMap = translatableText.getTranslationMap();
        for (String language : rankedLanguages) {
            String value = (String)translationMap.get(language);
            if (value == null) continue;
            return value;
        }
        return translatableText.getText();
    }
}

