/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;

public class ValueConverterUtils {
    public static String compressPrivilegeNames(List<Privilege> privileges) {
        if (privileges == null || privileges.isEmpty()) {
            return null;
        }
        return privileges.stream().map(Privilege::getName).collect(Collectors.joining("\n"));
    }

    public static String compressPrivilegeObjectIds(List<PrivilegeObject> privilegeObjects) {
        if (privilegeObjects == null || privilegeObjects.isEmpty()) {
            return null;
        }
        return privilegeObjects.stream().map(PrivilegeObject::getId).map(id -> "" + id).collect(Collectors.joining("\n"));
    }

    public static String compressStringList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\n", list);
    }

    public static List<String> decompressToStringList(String value) {
        if (value == null || value.isBlank()) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split("\n")).filter(n -> n != null && !n.isBlank()).collect(Collectors.toList());
    }

    public static List<Integer> decompressIds(String ids) {
        if (ids == null || ids.isBlank()) {
            return Collections.emptyList();
        }
        return Arrays.stream(ids.split("\n")).filter(n -> n != null && !n.isBlank()).map(Integer::parseInt).collect(Collectors.toList());
    }
}

