package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface CountryQuery extends Query<Country> {

    static CountryQuery create() {
        return new UdbCountryQuery();
    }

    CountryQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    CountryQuery parseFullTextFilter(String query, String... fieldNames);

	CountryQuery metaCreationDate(NumericFilter filter);

	CountryQuery orMetaCreationDate(NumericFilter filter);

	CountryQuery metaCreatedBy(NumericFilter filter);

	CountryQuery orMetaCreatedBy(NumericFilter filter);

	CountryQuery metaModificationDate(NumericFilter filter);

	CountryQuery orMetaModificationDate(NumericFilter filter);

	CountryQuery metaModifiedBy(NumericFilter filter);

	CountryQuery orMetaModifiedBy(NumericFilter filter);

	CountryQuery metaDeletionDate(NumericFilter filter);

	CountryQuery orMetaDeletionDate(NumericFilter filter);

	CountryQuery metaDeletedBy(NumericFilter filter);

	CountryQuery orMetaDeletedBy(NumericFilter filter);

	CountryQuery metaRestoreDate(NumericFilter filter);

	CountryQuery orMetaRestoreDate(NumericFilter filter);

	CountryQuery metaRestoredBy(NumericFilter filter);

	CountryQuery orMetaRestoredBy(NumericFilter filter);

	CountryQuery isoCode(TextFilter filter);

	CountryQuery orIsoCode(TextFilter filter);

	CountryQuery icon(TextFilter filter);

	CountryQuery orIcon(TextFilter filter);

	CountryQuery englishDisplayName(TextFilter filter);

	CountryQuery orEnglishDisplayName(TextFilter filter);

	CountryQuery filterLocalizationKey(LocalizationKeyQuery query);

	CountryQuery localizationKey(NumericFilter filter);

	CountryQuery orLocalizationKey(NumericFilter filter);

	CountryQuery addressFormat(TextFilter filter);

	CountryQuery orAddressFormat(TextFilter filter);

	CountryQuery filterMainLanguage(LanguageQuery query);

	CountryQuery mainLanguage(NumericFilter filter);

	CountryQuery orMainLanguage(NumericFilter filter);

	CountryQuery filterOtherLanguages(LanguageQuery query);

	CountryQuery otherLanguages(MultiReferenceFilterType type, Language ... value);

	CountryQuery otherLanguagesCount(MultiReferenceFilterType type, int count);

	CountryQuery otherLanguages(MultiReferenceFilter filter);

	CountryQuery orOtherLanguages(MultiReferenceFilter filter);

	CountryQuery filterCurrency(CurrencyQuery query);

	CountryQuery currency(NumericFilter filter);

	CountryQuery orCurrency(NumericFilter filter);

	CountryQuery filterOtherCurrencies(CurrencyQuery query);

	CountryQuery otherCurrencies(MultiReferenceFilterType type, Currency ... value);

	CountryQuery otherCurrenciesCount(MultiReferenceFilterType type, int count);

	CountryQuery otherCurrencies(MultiReferenceFilter filter);

	CountryQuery orOtherCurrencies(MultiReferenceFilter filter);


    CountryQuery andOr(CountryQuery... queries);

    CountryQuery customFilter(Function<Country, Boolean> customFilter);

    List<Country> execute();

    List<Country> executeOnDeletedRecords();

    Country executeExpectSingleton();

    BitSet executeToBitSet();

    List<Country> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Country> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

