package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface CurrencyQuery extends Query<Currency> {

    static CurrencyQuery create() {
        return new UdbCurrencyQuery();
    }

    CurrencyQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    CurrencyQuery parseFullTextFilter(String query, String... fieldNames);

	CurrencyQuery metaCreationDate(NumericFilter filter);

	CurrencyQuery orMetaCreationDate(NumericFilter filter);

	CurrencyQuery metaCreatedBy(NumericFilter filter);

	CurrencyQuery orMetaCreatedBy(NumericFilter filter);

	CurrencyQuery metaModificationDate(NumericFilter filter);

	CurrencyQuery orMetaModificationDate(NumericFilter filter);

	CurrencyQuery metaModifiedBy(NumericFilter filter);

	CurrencyQuery orMetaModifiedBy(NumericFilter filter);

	CurrencyQuery metaDeletionDate(NumericFilter filter);

	CurrencyQuery orMetaDeletionDate(NumericFilter filter);

	CurrencyQuery metaDeletedBy(NumericFilter filter);

	CurrencyQuery orMetaDeletedBy(NumericFilter filter);

	CurrencyQuery metaRestoreDate(NumericFilter filter);

	CurrencyQuery orMetaRestoreDate(NumericFilter filter);

	CurrencyQuery metaRestoredBy(NumericFilter filter);

	CurrencyQuery orMetaRestoredBy(NumericFilter filter);


    CurrencyQuery andOr(CurrencyQuery... queries);

    CurrencyQuery customFilter(Function<Currency, Boolean> customFilter);

    List<Currency> execute();

    List<Currency> executeOnDeletedRecords();

    Currency executeExpectSingleton();

    BitSet executeToBitSet();

    List<Currency> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Currency> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

