package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface SystemSettingsQuery extends Query<SystemSettings> {

    static SystemSettingsQuery create() {
        return new UdbSystemSettingsQuery();
    }

    SystemSettingsQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    SystemSettingsQuery parseFullTextFilter(String query, String... fieldNames);

	SystemSettingsQuery metaCreationDate(NumericFilter filter);

	SystemSettingsQuery orMetaCreationDate(NumericFilter filter);

	SystemSettingsQuery metaCreatedBy(NumericFilter filter);

	SystemSettingsQuery orMetaCreatedBy(NumericFilter filter);

	SystemSettingsQuery metaModificationDate(NumericFilter filter);

	SystemSettingsQuery orMetaModificationDate(NumericFilter filter);

	SystemSettingsQuery metaModifiedBy(NumericFilter filter);

	SystemSettingsQuery orMetaModifiedBy(NumericFilter filter);

	SystemSettingsQuery metaDeletionDate(NumericFilter filter);

	SystemSettingsQuery orMetaDeletionDate(NumericFilter filter);

	SystemSettingsQuery metaDeletedBy(NumericFilter filter);

	SystemSettingsQuery orMetaDeletedBy(NumericFilter filter);

	SystemSettingsQuery metaRestoreDate(NumericFilter filter);

	SystemSettingsQuery orMetaRestoreDate(NumericFilter filter);

	SystemSettingsQuery metaRestoredBy(NumericFilter filter);

	SystemSettingsQuery orMetaRestoredBy(NumericFilter filter);

	SystemSettingsQuery allowedBaseLanguages(TextFilter filter);

	SystemSettingsQuery orAllowedBaseLanguages(TextFilter filter);


    SystemSettingsQuery andOr(SystemSettingsQuery... queries);

    SystemSettingsQuery customFilter(Function<SystemSettings, Boolean> customFilter);

    List<SystemSettings> execute();

    List<SystemSettings> executeOnDeletedRecords();

    SystemSettings executeExpectSingleton();

    BitSet executeToBitSet();

    List<SystemSettings> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<SystemSettings> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

