package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbCurrencyQuery extends AbstractUdbQuery<Currency> implements CurrencyQuery {

    public UdbCurrencyQuery() {
        super(UdbCurrency.table, Currency.getBuilder());
    }

	@Override
	public CurrencyQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbCurrency.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public CurrencyQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbCurrency.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public CurrencyQuery metaCreationDate(NumericFilter filter) {
		and(UdbCurrency.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbCurrency.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery metaCreatedBy(NumericFilter filter) {
		and(UdbCurrency.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbCurrency.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery metaModificationDate(NumericFilter filter) {
		and(UdbCurrency.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbCurrency.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery metaModifiedBy(NumericFilter filter) {
		and(UdbCurrency.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbCurrency.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery metaDeletionDate(NumericFilter filter) {
		and(UdbCurrency.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbCurrency.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery metaDeletedBy(NumericFilter filter) {
		and(UdbCurrency.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbCurrency.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery metaRestoreDate(NumericFilter filter) {
		and(UdbCurrency.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbCurrency.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery metaRestoredBy(NumericFilter filter) {
		and(UdbCurrency.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public CurrencyQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbCurrency.metaRestoredBy.createFilter(filter));
		return this;
	}


	@Override
	public UdbCurrencyQuery andOr(CurrencyQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public CurrencyQuery customFilter(Function<Currency, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Currency.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



