package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbLanguageQuery extends AbstractUdbQuery<Language> implements LanguageQuery {

    public UdbLanguageQuery() {
        super(UdbLanguage.table, Language.getBuilder());
    }

	@Override
	public LanguageQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbLanguage.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public LanguageQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbLanguage.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public LanguageQuery metaCreationDate(NumericFilter filter) {
		and(UdbLanguage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbLanguage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery metaCreatedBy(NumericFilter filter) {
		and(UdbLanguage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbLanguage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery metaModificationDate(NumericFilter filter) {
		and(UdbLanguage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbLanguage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery metaModifiedBy(NumericFilter filter) {
		and(UdbLanguage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbLanguage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery metaDeletionDate(NumericFilter filter) {
		and(UdbLanguage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbLanguage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery metaDeletedBy(NumericFilter filter) {
		and(UdbLanguage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbLanguage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery metaRestoreDate(NumericFilter filter) {
		and(UdbLanguage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbLanguage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery metaRestoredBy(NumericFilter filter) {
		and(UdbLanguage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbLanguage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery isoCode(TextFilter filter) {
		and(UdbLanguage.isoCode.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orIsoCode(TextFilter filter) {
		or(UdbLanguage.isoCode.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery icon(TextFilter filter) {
		and(UdbLanguage.icon.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orIcon(TextFilter filter) {
		or(UdbLanguage.icon.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery englishDisplayName(TextFilter filter) {
		and(UdbLanguage.englishDisplayName.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orEnglishDisplayName(TextFilter filter) {
		or(UdbLanguage.englishDisplayName.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery nonLatinScript(BooleanFilter filter) {
		and(UdbLanguage.nonLatinScript.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orNonLatinScript(BooleanFilter filter) {
		or(UdbLanguage.nonLatinScript.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery rightToLeftLanguage(BooleanFilter filter) {
		and(UdbLanguage.rightToLeftLanguage.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orRightToLeftLanguage(BooleanFilter filter) {
		or(UdbLanguage.rightToLeftLanguage.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery filterLocalizationKey(LocalizationKeyQuery query) {
		UdbLocalizationKeyQuery udbQuery = (UdbLocalizationKeyQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLanguage.localizationKey);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LanguageQuery localizationKey(NumericFilter filter) {
		and(UdbLanguage.localizationKey.createFilter(filter));
		return this;
	}

	@Override
	public LanguageQuery orLocalizationKey(NumericFilter filter) {
		or(UdbLanguage.localizationKey.createFilter(filter));
		return this;
	}


	@Override
	public UdbLanguageQuery andOr(LanguageQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public LanguageQuery customFilter(Function<Language, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Language.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



