package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbManagedApplicationGroupQuery extends AbstractUdbQuery<ManagedApplicationGroup> implements ManagedApplicationGroupQuery {

    public UdbManagedApplicationGroupQuery() {
        super(UdbManagedApplicationGroup.table, ManagedApplicationGroup.getBuilder());
    }

	@Override
	public ManagedApplicationGroupQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbManagedApplicationGroup.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbManagedApplicationGroup.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaCreationDate(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaCreatedBy(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaModificationDate(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaModifiedBy(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaDeletionDate(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaDeletedBy(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaRestoreDate(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery metaRestoredBy(NumericFilter filter) {
		and(UdbManagedApplicationGroup.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbManagedApplicationGroup.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery icon(TextFilter filter) {
		and(UdbManagedApplicationGroup.icon.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orIcon(TextFilter filter) {
		or(UdbManagedApplicationGroup.icon.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery titleKey(TextFilter filter) {
		and(UdbManagedApplicationGroup.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orTitleKey(TextFilter filter) {
		or(UdbManagedApplicationGroup.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery filterApplications(ManagedApplicationQuery query) {
		UdbManagedApplicationQuery udbQuery = (UdbManagedApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbManagedApplicationGroup.applications, UdbManagedApplication.applicationGroup);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery applications(MultiReferenceFilterType type, ManagedApplication ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ManagedApplication value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbManagedApplicationGroup.applications.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery applicationsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbManagedApplicationGroup.applications.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery applications(MultiReferenceFilter filter) {
		and(UdbManagedApplicationGroup.applications.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orApplications(MultiReferenceFilter filter) {
		or(UdbManagedApplicationGroup.applications.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery listingPosition(NumericFilter filter) {
		and(UdbManagedApplicationGroup.listingPosition.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationGroupQuery orListingPosition(NumericFilter filter) {
		or(UdbManagedApplicationGroup.listingPosition.createFilter(filter));
		return this;
	}


	@Override
	public UdbManagedApplicationGroupQuery andOr(ManagedApplicationGroupQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ManagedApplicationGroupQuery customFilter(Function<ManagedApplicationGroup, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ManagedApplicationGroup.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



