/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.accesscontrol;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.tools.RecordListModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.form.FormPanel;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.RoleApplicationRoleAssignment;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.ComboBoxModel;

public class AccessControlAppRolePerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();

    public AccessControlAppRolePerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        Supplier<Query> querySupplier = () -> this.isAppFilter() ? RoleApplicationRoleAssignment.filter().organizationFieldFilter(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())) : RoleApplicationRoleAssignment.filter();
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.KEYS, this.getLocalized("accessControl.accessControlListEntries"), this.getApplicationInstanceData(), querySupplier, Privileges.ACCESS_CONTROL_APP_ROLE_PERSPECTIVE);
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Table table = entityModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        entityModelBuilder.updateModels();
        TemplateField roleTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()));
        TemplateField applicationTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
        TemplateField<RoleApplicationRoleAssignment> applicationRoleTemplateField = this.createApplicationRoleTemplateField();
        TemplateField customOrganizationUnitTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("role", this.getLocalized("roles.role"), (AbstractField)roleTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("application", this.getLocalized("applications.application"), (AbstractField)applicationTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("applicationRoleName", this.getLocalized("accessControl.applicationRole"), applicationRoleTemplateField).setDefaultWidth(200));
        table.addColumn(new TableColumn("fixedOrganizationRoot", this.getLocalized("accessControl.customOrganizationUnit"), (AbstractField)customOrganizationUnitTableField).setDefaultWidth(200));
        table.setPropertyExtractor((rolePrivilegeAssignment, propertyName) -> switch (propertyName) {
            case "role" -> rolePrivilegeAssignment.getRole();
            case "application" -> rolePrivilegeAssignment.getApplication();
            case "applicationRoleName" -> rolePrivilegeAssignment;
            case "fixedOrganizationRoot" -> rolePrivilegeAssignment.getFixedOrganizationRoot();
            default -> null;
        });
        ComboBox roleComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll(), PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        ComboBox<Application> applicationComboBox = this.createApplicationComboBox();
        ComboBox<ApplicationRole> applicationRoleComboBox = this.createApplicationRoleComboBox(applicationComboBox);
        ComboBox<OrganizationField> organizationFieldFilterComboBox = this.createOrganizationFieldComboBox();
        ComboBox<OrganizationUnit> organizationFilterComboBox = OrganizationUtils.createOrganizationComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, OrganizationUnit.getAll(), true, this.getApplicationInstanceData());
        TagComboBox<OrganizationUnitType> organizationUnitTypeFilterTagComboBox = OrganizationUtils.createOrganizationUnitTypeTagComboBox(50, this.getApplicationInstanceData());
        RecordListModelBuilder appRoleModelBuilder = new RecordListModelBuilder(this.getApplicationInstanceData());
        Table privilegeGroupTable = appRoleModelBuilder.createListTable(true);
        TemplateField privilegeGroupTemplateField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createPrivilegeGroupPropertyProvider(this.getApplicationInstanceData()));
        TagComboBox privilegeTagComboBox = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createPrivilegePropertyProvider(this.getApplicationInstanceData()));
        privilegeGroupTable.addColumn(new TableColumn("group", this.getLocalized("accessControl.privilegeGroup"), (AbstractField)privilegeGroupTemplateField));
        privilegeGroupTable.addColumn(new TableColumn("privileges", this.getLocalized("accessControl.privileges"), (AbstractField)privilegeTagComboBox));
        privilegeGroupTable.setPropertyExtractor((record, propertyName) -> switch (propertyName) {
            case "group" -> record;
            case "privileges" -> record.getPrivileges();
            default -> null;
        });
        FormPanel formPanel = new FormPanel(this.getApplicationInstanceData());
        formPanel.setTable(privilegeGroupTable, true, false, false);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("roles.role"), (AbstractField)roleComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.application"), applicationComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.applicationRole"), applicationRoleComboBox);
        if (!this.isOrgFieldFilterApplied()) {
            formLayout.addLabelAndField(null, this.getLocalized("accessControl.organizationFieldFilter"), organizationFieldFilterComboBox);
        }
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.customOrganizationUnit"), organizationFilterComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.organizationUnitTypeFilter"), organizationUnitTypeFilterTagComboBox);
        formLayout.addSection(ApplicationIcons.SECURITY_BADGE, this.getLocalized("org.teamapps.dictionary.privileges"));
        formLayout.addLabelAndComponent(null, this.getLocalized("accessControl.applicationRolePrivileges"), (Component)formPanel.getPanel());
        applicationComboBox.onValueChanged.addListener(() -> applicationRoleComboBox.setValue(null));
        applicationRoleComboBox.onValueChanged.addListener(role -> appRoleModelBuilder.setRecords(role.getPrivilegeGroups()));
        masterDetailController.createViews(this.getPerspective(), (Component)table, formLayout);
        formController.addNotNull((AbstractField)roleComboBox);
        formController.addNotNull(applicationComboBox);
        formController.addNotNull(applicationRoleComboBox);
        formController.setSaveEntityHandler(roleApplicationRoleAssignment -> {
            OrganizationField organizationField = this.isAppFilter() ? this.getOrganizationField() : (OrganizationField)organizationFieldFilterComboBox.getValue();
            roleApplicationRoleAssignment.setRole((Role)roleComboBox.getValue()).setApplication((Application)applicationComboBox.getValue()).setApplicationRoleName(((ApplicationRole)applicationRoleComboBox.getValue()).getName()).setOrganizationFieldFilter(organizationField).setFixedOrganizationRoot((OrganizationUnit)organizationFilterComboBox.getValue()).setOrganizationUnitTypeFilter((List)organizationUnitTypeFilterTagComboBox.getValue());
            return true;
        });
        entityModelBuilder.getOnSelectionEvent().addListener(roleApplicationRoleAssignment -> {
            roleComboBox.setValue((Object)roleApplicationRoleAssignment.getRole());
            applicationComboBox.setValue((Object)roleApplicationRoleAssignment.getApplication());
            ApplicationRole applicationRole = this.getApplicationRole((RoleApplicationRoleAssignment)roleApplicationRoleAssignment);
            applicationRoleComboBox.setValue((Object)applicationRole);
            organizationFieldFilterComboBox.setValue((Object)roleApplicationRoleAssignment.getOrganizationFieldFilter());
            organizationFilterComboBox.setValue((Object)roleApplicationRoleAssignment.getFixedOrganizationRoot());
            organizationUnitTypeFilterTagComboBox.setValue(roleApplicationRoleAssignment.getOrganizationUnitTypeFilter());
            appRoleModelBuilder.setRecords(applicationRole != null ? applicationRole.getPrivilegeGroups() : Collections.emptyList());
        });
        entityModelBuilder.setSelectedRecord((Object)RoleApplicationRoleAssignment.create());
    }

    private ComboBox<OrganizationField> createOrganizationFieldComboBox() {
        return ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Collections.singletonList(this.getOrganizationField()) : OrganizationField.getAll(), PropertyProviders.createOrganizationFieldPropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    private ComboBox<ApplicationRole> createApplicationRoleComboBox(ComboBox<Application> applicationComboBox) {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        Supplier<List> recordsSupplier = () -> {
            LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication((Application)applicationComboBox.getValue());
            if (loadedApplication != null) {
                List applicationRoles = loadedApplication.getBaseApplicationBuilder().getApplicationRoles();
                return applicationRoles != null ? applicationRoles : Collections.emptyList();
            }
            return Collections.emptyList();
        };
        PropertyProvider propertyProvider = (applicationRole, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = this.userSessionData.getApplicationLocalizationProvider((Application)applicationComboBox.getValue());
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (localizationProvider == null) {
                return map;
            }
            map.put("icon", applicationRole.getIcon());
            map.put("caption", localizationProvider.getLocalized(applicationRole.getTitleKey(), new Object[0]));
            map.put("description", localizationProvider.getLocalized(applicationRole.getDescriptionKey(), new Object[0]));
            return map;
        };
        comboBox.setPropertyProvider(propertyProvider);
        Function recordToStringFunction = UiUtils.createRecordToStringFunction((PropertyProvider)propertyProvider);
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(query -> query == null || query.isBlank() ? (List)recordsSupplier.get() : ((List)recordsSupplier.get()).stream().filter(record -> ((String)recordToStringFunction.apply(record)).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }

    private TemplateField<RoleApplicationRoleAssignment> createApplicationRoleTemplateField() {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        PropertyProvider propertyProvider = (assignment, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = this.userSessionData.getApplicationLocalizationProvider(assignment.getApplication());
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (localizationProvider == null || assignment.getApplicationRoleName() == null) {
                return map;
            }
            ApplicationRole applicationRole = this.getApplicationRole((RoleApplicationRoleAssignment)assignment);
            if (applicationRole == null) {
                return map;
            }
            map.put("icon", applicationRole.getIcon());
            map.put("caption", localizationProvider.getLocalized(applicationRole.getTitleKey(), new Object[0]));
            map.put("description", localizationProvider.getLocalized(applicationRole.getDescriptionKey(), new Object[0]));
            return map;
        };
        templateField.setPropertyProvider(propertyProvider);
        return templateField;
    }

    private ApplicationRole getApplicationRole(RoleApplicationRoleAssignment assignment) {
        if (assignment == null || assignment.getApplication() == null || assignment.getApplicationRoleName() == null) {
            return null;
        }
        LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(assignment.getApplication());
        if (loadedApplication != null) {
            return loadedApplication.getBaseApplicationBuilder().getApplicationRoles().stream().filter(appRole -> assignment.getApplicationRoleName().equals(appRole.getName())).findAny().orElse(null);
        }
        return null;
    }

    private ComboBox<Application> createApplicationComboBox() {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<Application> propertyProvider = PropertyProviders.createApplicationPropertyProvider(this.userSessionData);
        Function recordToString = UiUtils.createRecordToStringFunction(propertyProvider);
        ComboBoxModel model = ComboBoxUtils.createComboBoxModel(this::getAvailableApplications, propertyProvider, (int)50, (String[])new String[0]);
        comboBox.setModel(model);
        comboBox.setPropertyProvider(propertyProvider);
        comboBox.setRecordToStringFunction(recordToString);
        return comboBox;
    }

    private List<Application> getAvailableApplications() {
        if (this.isAppFilter()) {
            return this.getManagedApplication().getPerspectives().stream().map(p -> p.getApplicationPerspective().getApplication()).distinct().collect(Collectors.toList());
        }
        return Application.getAll();
    }
}

