/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.applications;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.system.utils.ApplicationUiUtils;
import org.teamapps.application.server.ui.localize.LocalizationTranslationKeyField;
import org.teamapps.application.tools.EntityListModelBuilder;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.RecordComboBox;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.form.FormPanel;
import org.teamapps.application.ux.form.FormWindow;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;

public class ApplicationProvisioningPerspective
extends AbstractManagedApplicationPerspective {
    private final UserSessionData userSessionData;

    public ApplicationProvisioningPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.INSTALL, this.getLocalized("applicationProvisioning.provisionedApplications"), this.getApplicationInstanceData(), ManagedApplication::filter, Privileges.APPLICATION_PROVISIONING_PERSPECTIVE);
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Table applicationsTable = entityModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData), 60);
        applicationsTable.setStripedRows(false);
        entityModelBuilder.updateModels();
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(400);
        ComboBox<Application> applicationComboBox = ApplicationUiUtils.createApplicationComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, this.userSessionData);
        ComboBox<OrganizationField> organizationFieldCombo = OrganizationUtils.createOrganizationFieldCombo(this.getApplicationInstanceData());
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, (boolean)true);
        iconComboBox.setShowClearButton(true);
        LocalizationTranslationKeyField titleKeyField = new LocalizationTranslationKeyField(this.getLocalized("applications.createNewTitle"), this.getApplicationInstanceData(), this.userSessionData.getRegistry(), () -> applicationComboBox.getValue());
        LocalizationTranslationKeyField descriptionKeyField = new LocalizationTranslationKeyField(this.getLocalized("applications.createNewDescription"), this.getApplicationInstanceData(), this.userSessionData.getRegistry(), () -> applicationComboBox.getValue());
        ComboBox selectionField = (ComboBox)titleKeyField.getSelectionField();
        selectionField.setTemplate((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        CheckBox darkThemeCheckBox = new CheckBox(this.getLocalized("applications.darkTheme"));
        CheckBox toolbarAppMenuCheckbox = new CheckBox(this.getLocalized("applications.useToolbarApplicationMenu"));
        CheckBox startOnLoginCheckbox = new CheckBox(this.getLocalized("applications.startOnLogin"));
        EntityListModelBuilder perspectiveModelBuilder = new EntityListModelBuilder(this.getApplicationInstanceData());
        Table perspectivesList = perspectiveModelBuilder.createTable();
        perspectivesList.setDisplayAsList(true);
        perspectivesList.setForceFitWidth(true);
        perspectivesList.setRowHeight(26);
        TemplateField perspectiveColumnField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData));
        TemplateField applicationColumnField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
        perspectivesList.addColumn(new TableColumn("perspective", this.getLocalized("applications.perspective"), (AbstractField)perspectiveColumnField));
        perspectivesList.addColumn(new TableColumn("application", this.getLocalized("applications.application"), (AbstractField)applicationColumnField));
        perspectivesList.setPropertyExtractor((record, propertyName) -> switch (propertyName) {
            case "perspective" -> record;
            case "application" -> {
                if (record.getApplicationPerspective() != null) {
                    yield record.getApplicationPerspective().getApplication();
                }
                yield null;
            }
            default -> null;
        });
        perspectivesList.setStripedRows(false);
        FormPanel formPanel = new FormPanel(this.getApplicationInstanceData());
        formPanel.setTable(perspectivesList, true, true, true);
        formPanel.addButtonGroup();
        ToolbarButton moveUpButton = formPanel.addButton(ApplicationIcons.NAVIGATE_UP, this.getLocalized("applications.moveUp"));
        ToolbarButton moveDownButton = formPanel.addButton(ApplicationIcons.NAVIGATE_DOWN, this.getLocalized("applications.moveDown"));
        CheckBox hideApplicationCheckBox = new CheckBox(this.getLocalized("org.teamapps.dictionary.hide"));
        ComboBox<ManagedApplicationGroup> applicationGroupComboBox = ApplicationUiUtils.createApplicationGroupComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.getApplicationInstanceData());
        Arrays.asList(applicationComboBox, iconComboBox, titleKeyField.getKeyDisplayField(), descriptionKeyField.getKeyDisplayField(), applicationGroupComboBox).forEach(f -> f.setRequired(true));
        formLayout.addSection().setDrawHeaderLine(false).setCollapsible(false);
        formLayout.addLabelAndField(null, this.getLocalized("applications.mainApplication"), applicationComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.hidden"), (AbstractField)hideApplicationCheckBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.organizationField"), organizationFieldCombo);
        formLayout.addLabelAndField(null, this.getLocalized("applications.applicationIcon"), (AbstractField)iconComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.appTitle"), titleKeyField.getSelectionField());
        formLayout.addLabelAndComponent(null, null, (Component)titleKeyField.getKeyLinkButton());
        formLayout.addLabelAndField(null, this.getLocalized("applications.appDescription"), descriptionKeyField.getSelectionField());
        formLayout.addLabelAndComponent(null, null, (Component)descriptionKeyField.getKeyLinkButton());
        formLayout.addLabelAndField(null, this.getLocalized("applications.darkTheme"), (AbstractField)darkThemeCheckBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.toolbarAppMenu"), (AbstractField)toolbarAppMenuCheckbox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.startOnLogin"), (AbstractField)startOnLoginCheckbox);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.perspectives"), (Component)formPanel.getPanel());
        formLayout.addLabelAndField(null, this.getLocalized("applications.applicationGroup"), applicationGroupComboBox);
        formPanel.getAddButton().onClick.addListener(() -> this.showPerspectiveFormWindow(null, (EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder));
        formPanel.getEditButton().onClick.addListener(() -> this.showPerspectiveFormWindow((ManagedApplicationPerspective)perspectivesList.getSelectedRecord(), (EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder));
        formPanel.getDeleteButton().onClick.addListener(() -> perspectiveModelBuilder.removeRecord((Object)((ManagedApplicationPerspective)perspectivesList.getSelectedRecord())));
        masterDetailController.createViews(this.getPerspective(), (Component)applicationsTable, formLayout);
        formController.addNotNull(applicationComboBox);
        formController.addNotNull(titleKeyField.getSelectionField());
        formController.addNotNull(descriptionKeyField.getSelectionField());
        formController.addNotNull(applicationGroupComboBox);
        formController.setSaveEntityHandler(application -> {
            if (!perspectiveModelBuilder.getRecords().isEmpty() || application.isSingleApplication() || application.getMainApplication().isUnmanagedApplication()) {
                Application mainApplication = (Application)applicationComboBox.getValue();
                application.setMainApplication(mainApplication);
                application.setHidden((Boolean)hideApplicationCheckBox.getValue());
                application.setOrganizationField((OrganizationField)organizationFieldCombo.getValue());
                application.setIcon(mainApplication.getIcon().equals(IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue()))) ? null : IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue())));
                application.setTitleKey(mainApplication.getTitleKey().equals(titleKeyField.getKey()) ? null : titleKeyField.getKey());
                application.setDescriptionKey(mainApplication.getDescriptionKey().equals(descriptionKeyField.getKey()) ? null : descriptionKeyField.getKey());
                application.setDarkTheme((Boolean)darkThemeCheckBox.getValue());
                application.setToolbarApplicationMenu((Boolean)toolbarAppMenuCheckbox.getValue());
                application.setStartOnLogin((Boolean)startOnLoginCheckbox.getValue());
                application.setPerspectives(perspectiveModelBuilder.getRecords());
                application.setApplicationGroup((ManagedApplicationGroup)applicationGroupComboBox.getValue());
                application.save();
                int pos = 0;
                for (ManagedApplicationPerspective perspective : perspectiveModelBuilder.getRecords()) {
                    perspective.setListingPosition(pos++).save();
                }
                return true;
            }
            return false;
        });
        moveUpButton.onClick.addListener(() -> this.changePerspectiveOrder((EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder, (Table<ManagedApplicationPerspective>)perspectivesList, true));
        moveDownButton.onClick.addListener(() -> this.changePerspectiveOrder((EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder, (Table<ManagedApplicationPerspective>)perspectivesList, false));
        applicationComboBox.onValueChanged.addListener(app -> {
            iconComboBox.setValue(app != null ? IconUtils.decodeIcon((String)app.getIcon()) : null);
            titleKeyField.setKey(app != null ? app.getTitleKey() : null);
            descriptionKeyField.setKey(app != null ? app.getDescriptionKey() : null);
            ManagedApplication selectedRecord = (ManagedApplication)entityModelBuilder.getSelectedRecord();
            if (selectedRecord != null && !selectedRecord.isStored()) {
                List perspectives = app.getPerspectives().stream().filter(ApplicationPerspective::getAutoProvision).map(p -> ManagedApplicationPerspective.create().setApplicationPerspective((ApplicationPerspective)p)).collect(Collectors.toList());
                perspectiveModelBuilder.setRecords(perspectives);
            }
        });
        entityModelBuilder.getOnSelectionEvent().addListener(app -> {
            applicationComboBox.setValue((Object)app.getMainApplication());
            hideApplicationCheckBox.setValue((Object)app.getHidden());
            organizationFieldCombo.setValue((Object)app.getOrganizationField());
            iconComboBox.setValue(app.getIcon() != null ? IconUtils.decodeIcon((String)app.getIcon()) : (app.getMainApplication() != null ? IconUtils.decodeIcon((String)app.getMainApplication().getIcon()) : null));
            titleKeyField.setKey(app.getTitleKey() != null ? app.getTitleKey() : (app.getMainApplication() != null ? app.getMainApplication().getTitleKey() : null));
            descriptionKeyField.setKey(app.getDescriptionKey() != null ? app.getDescriptionKey() : (app.getMainApplication() != null ? app.getMainApplication().getDescriptionKey() : null));
            darkThemeCheckBox.setValue((Object)app.isDarkTheme());
            toolbarAppMenuCheckbox.setValue((Object)app.isToolbarApplicationMenu());
            startOnLoginCheckbox.setValue((Object)app.isStartOnLogin());
            perspectiveModelBuilder.setRecords(app.getPerspectives().stream().filter(perspective -> perspective.getApplicationPerspective() != null).sorted(Comparator.comparingInt(ManagedApplicationPerspective::getListingPosition)).collect(Collectors.toList()));
            applicationGroupComboBox.setValue((Object)app.getApplicationGroup());
        });
        entityModelBuilder.setSelectedRecord((Object)ManagedApplication.create());
    }

    private void showPerspectiveFormWindow(ManagedApplicationPerspective managedApplicationPerspective, EntityListModelBuilder<ManagedApplicationPerspective> perspectiveModelBuilder) {
        ManagedApplicationPerspective perspective = managedApplicationPerspective != null ? managedApplicationPerspective : ManagedApplicationPerspective.create();
        FormWindow formWindow = new FormWindow(ApplicationIcons.WINDOWS, this.getLocalized("applications.perspective"), this.getApplicationInstanceData());
        formWindow.addSaveButton();
        formWindow.addCancelButton();
        formWindow.addSection();
        ComboBox<Application> applicationComboBox = ApplicationUiUtils.createApplicationComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.userSessionData);
        RecordComboBox applicationsPerspectiveCombo = new RecordComboBox(PropertyProviders.createApplicationPerspectivePropertyProvider(this.userSessionData), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, (boolean)true);
        LocalizationTranslationKeyField titleKeyField = new LocalizationTranslationKeyField(this.getLocalized("applications.createNewTitle"), this.getApplicationInstanceData(), this.userSessionData.getRegistry(), () -> applicationComboBox.getValue());
        LocalizationTranslationKeyField descriptionKeyField = new LocalizationTranslationKeyField(this.getLocalized("applications.createNewDescription"), this.getApplicationInstanceData(), this.userSessionData.getRegistry(), () -> applicationComboBox.getValue());
        CheckBox toolbarPerspectiveMenuCheckBox = new CheckBox(this.getLocalized("applications.useToolbarPerspectiveMenu"));
        formWindow.addField(this.getLocalized("applications.application"), applicationComboBox);
        formWindow.addField(this.getLocalized("applications.perspective"), (Component)applicationsPerspectiveCombo);
        formWindow.addField(this.getLocalized("applications.perspectiveIcon"), (Component)iconComboBox);
        formWindow.addField(this.getLocalized("applications.perspectiveTitle"), titleKeyField.getSelectionField());
        formWindow.addField(null, (Component)titleKeyField.getKeyLinkButton());
        formWindow.addField(this.getLocalized("applications.perspectiveDescription"), descriptionKeyField.getSelectionField());
        formWindow.addField(null, (Component)descriptionKeyField.getKeyLinkButton());
        formWindow.addField(this.getLocalized("applications.toolbarPerspectiveMenu"), (Component)toolbarPerspectiveMenuCheckBox);
        if (managedApplicationPerspective != null) {
            applicationComboBox.setValue((Object)perspective.getApplicationPerspective().getApplication());
            applicationsPerspectiveCombo.setValue((Object)perspective.getApplicationPerspective());
            iconComboBox.setValue((Object)(perspective.getIconOverride() != null ? IconUtils.decodeIcon((String)perspective.getIconOverride()) : IconUtils.decodeIcon((String)perspective.getApplicationPerspective().getIcon())));
            titleKeyField.setKey(perspective.getTitleKeyOverride() != null ? perspective.getTitleKeyOverride() : perspective.getApplicationPerspective().getTitleKey());
            descriptionKeyField.setKey(perspective.getDescriptionKeyOverride() != null ? perspective.getDescriptionKeyOverride() : perspective.getApplicationPerspective().getDescriptionKey());
            toolbarPerspectiveMenuCheckBox.setValue((Object)perspective.getToolbarPerspectiveMenu());
        }
        Arrays.asList(applicationsPerspectiveCombo, iconComboBox, titleKeyField.getSelectionField(), descriptionKeyField.getSelectionField(), applicationsPerspectiveCombo).forEach(f -> f.setRequired(true));
        applicationComboBox.onValueChanged.addListener(app -> applicationsPerspectiveCombo.setRecords(app.getPerspectives()));
        applicationsPerspectiveCombo.onValueChanged.addListener(p -> {
            iconComboBox.setValue(p != null ? IconUtils.decodeIcon((String)p.getIcon()) : null);
            titleKeyField.setKey(p != null ? p.getTitleKey() : null);
            descriptionKeyField.setKey(p != null ? p.getDescriptionKey() : null);
        });
        formWindow.getSaveButton().onClick.addListener(() -> {
            if (Fields.validateAll((AbstractField[])new AbstractField[]{applicationsPerspectiveCombo, iconComboBox, titleKeyField.getSelectionField(), descriptionKeyField.getSelectionField(), applicationsPerspectiveCombo})) {
                ApplicationPerspective applicationPerspective = (ApplicationPerspective)applicationsPerspectiveCombo.getValue();
                perspective.setApplicationPerspective(applicationPerspective);
                perspective.setIconOverride(applicationPerspective.getIcon().equals(iconComboBox.getValue()) ? null : IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue())));
                perspective.setTitleKeyOverride(applicationPerspective.getTitleKey().equals(titleKeyField.getKey()) ? null : titleKeyField.getKey());
                perspective.setDescriptionKeyOverride(applicationPerspective.getDescriptionKey().equals(descriptionKeyField.getKey()) ? null : descriptionKeyField.getKey());
                perspective.setToolbarPerspectiveMenu((Boolean)toolbarPerspectiveMenuCheckBox.getValue());
                perspective.save();
                if (managedApplicationPerspective == null) {
                    perspectiveModelBuilder.addRecord((Object)perspective);
                }
                formWindow.close();
            }
        });
        formWindow.show();
    }

    private void changePerspectiveOrder(EntityListModelBuilder<ManagedApplicationPerspective> perspectiveModelBuilder, Table<ManagedApplicationPerspective> perspectivesList, boolean moveUp) {
        ManagedApplicationPerspective selectedPerspective = (ManagedApplicationPerspective)perspectivesList.getSelectedRecord();
        if (selectedPerspective != null) {
            List perspectives = perspectiveModelBuilder.getRecords();
            int position = 0;
            int changeValue = moveUp ? -5 : 15;
            for (ManagedApplicationPerspective perspective : perspectives) {
                if (perspective.equals(selectedPerspective)) {
                    perspective.setListingPosition(position + changeValue);
                    continue;
                }
                perspective.setListingPosition(position += 10);
            }
            perspectiveModelBuilder.setRecords(perspectives.stream().sorted(Comparator.comparingInt(ManagedApplicationPerspective::getListingPosition)).collect(Collectors.toList()));
        }
    }
}

