/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.auth.AuthenticationHandler;
import org.teamapps.application.server.system.auth.UrlAuthenticationHandler;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.BaseResourceLinkProvider;
import org.teamapps.application.server.system.bootstrap.BootstrapSessionHandler;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstaller;
import org.teamapps.application.server.system.config.DocumentConversionConfig;
import org.teamapps.application.server.system.config.MachineTranslationConfig;
import org.teamapps.application.server.system.config.SystemConfig;
import org.teamapps.application.server.system.localization.DictionaryLocalizationProvider;
import org.teamapps.application.server.system.localization.GlobalLocalizationProvider;
import org.teamapps.application.server.system.localization.LocalizationUtil;
import org.teamapps.application.server.system.localization.SystemLocalizationProvider;
import org.teamapps.application.server.system.machinetranslation.MachineTranslation;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.application.server.system.server.SessionRegistryHandler;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.UniversalDB;

public class SystemRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BootstrapSessionHandler bootstrapSessionHandler;
    private final UniversalDB universalDB;
    private final ApplicationConfig<SystemConfig> applicationConfig;
    private TranslationService translationService;
    private final DictionaryLocalizationProvider dictionary;
    private final SystemLocalizationProvider systemDictionary;
    private final GlobalLocalizationProvider globalLocalizationProvider;
    private final Map<Application, LoadedApplication> loadedApplicationMap = new HashMap<Application, LoadedApplication>();
    private final ManagedApplicationGroup unspecifiedApplicationGroup;
    private final BaseResourceLinkProvider baseResourceLinkProvider;
    private SessionRegistryHandler sessionRegistryHandler;
    private DocumentConverter documentConverter;
    private List<AuthenticationHandler> authenticationHandlers = new ArrayList<AuthenticationHandler>();

    public SystemRegistry(BootstrapSessionHandler bootstrapSessionHandler, UniversalDB universalDB, ApplicationConfig<SystemConfig> applicationConfig) {
        SystemConfig systemConfig = (SystemConfig)applicationConfig.getConfig();
        this.bootstrapSessionHandler = bootstrapSessionHandler;
        this.universalDB = universalDB;
        this.applicationConfig = applicationConfig;
        this.systemDictionary = new SystemLocalizationProvider();
        this.dictionary = new DictionaryLocalizationProvider(systemConfig.getLocalizationConfig());
        this.globalLocalizationProvider = new GlobalLocalizationProvider(this);
        this.baseResourceLinkProvider = new BaseResourceLinkProvider();
        this.unspecifiedApplicationGroup = this.getOrCreateUnspecifiedApplicationGroup();
        this.authenticationHandlers.add(new UrlAuthenticationHandler(() -> ((SystemConfig)applicationConfig.getConfig()).getAuthenticationConfig()));
        applicationConfig.onConfigUpdate.addListener(this::handleConfigUpdate);
        this.handleConfigUpdate();
    }

    private void handleConfigUpdate() {
        MachineTranslationConfig machineTranslationConfig;
        SystemConfig config = (SystemConfig)this.applicationConfig.getConfig();
        DocumentConversionConfig documentConversionConfig = config.getDocumentConversionConfig();
        if (documentConversionConfig.isActive()) {
            this.documentConverter = DocumentConverter.createRemoteConverter((String)documentConversionConfig.getHost(), (String)documentConversionConfig.getUser(), (String)documentConversionConfig.getPassword());
        }
        if ((machineTranslationConfig = config.getMachineTranslationConfig()).isActive()) {
            MachineTranslation machineTranslation = new MachineTranslation();
            machineTranslation.setGoogleTranslationKey(machineTranslationConfig.getGoogleKey());
            machineTranslation.setDeepLKey(machineTranslationConfig.getDeepLKey(), machineTranslationConfig.isDeepLFreeApi());
            if (this.translationService == null) {
                this.dictionary.translateDictionary(machineTranslation);
            }
            this.translationService = machineTranslation;
        }
    }

    public void updateGlobalLocalizationProvider() {
        this.globalLocalizationProvider.updateLocalizationData();
        this.systemDictionary.update();
    }

    public void machineTranslateMissingEntries() {
        if (this.translationService != null) {
            LocalizationUtil.translateAllValues(this.translationService, this.getSystemConfig().getLocalizationConfig());
        }
    }

    private ManagedApplicationGroup getOrCreateUnspecifiedApplicationGroup() {
        if (ManagedApplicationGroup.getCount() == 0) {
            return (ManagedApplicationGroup)ManagedApplicationGroup.create().setIcon(IconUtils.encodeNoStyle((Icon)ApplicationIcons.HOME)).setTitleKey("org.teamapps.dictionary.applications").save();
        }
        return ManagedApplicationGroup.getAll().get(0);
    }

    public ApplicationInstaller createJarInstaller(File jarFile) {
        return ApplicationInstaller.createJarInstaller(jarFile, this.universalDB, this.translationService, this.getSystemConfig().getLocalizationConfig());
    }

    public boolean installAndLoadApplication(BaseApplicationBuilder baseApplicationBuilder) {
        ApplicationInstaller applicationInstaller = ApplicationInstaller.createClassInstaller(baseApplicationBuilder, this.universalDB, this.translationService, this.getSystemConfig().getLocalizationConfig());
        return this.installAndLoadApplication(applicationInstaller);
    }

    public boolean installAndLoadApplication(ApplicationInstaller applicationInstaller) {
        if (!applicationInstaller.isInstalled()) {
            if (applicationInstaller.installApplication()) {
                ApplicationInfo applicationInfo = applicationInstaller.getApplicationInfo();
                Application application = applicationInfo.getApplication();
                if (application.getVersions().size() == 1) {
                    ManagedApplication managedApplication = (ManagedApplication)ManagedApplication.create().setMainApplication(application).setApplicationGroup(this.unspecifiedApplicationGroup).setSingleApplication(applicationInfo.isUnmanagedPerspectives()).save();
                    List perspectives = application.getPerspectives().stream().filter(ApplicationPerspective::getAutoProvision).collect(Collectors.toList());
                    for (ApplicationPerspective perspective : perspectives) {
                        ManagedApplicationPerspective.create().setManagedApplication(managedApplication).setApplicationPerspective(perspective).save();
                    }
                }
            } else {
                LOGGER.error("Error installing " + applicationInstaller.getApplicationInfo().getName() + ": " + applicationInstaller.getApplicationInfo().getErrorMessage() + "\nWarnings:" + applicationInstaller.getApplicationInfo().getWarningMessage());
                return false;
            }
        }
        this.loadApplication(applicationInstaller);
        return true;
    }

    public void loadApplication(ApplicationInstaller applicationInstaller) {
        try {
            LoadedApplication loadedApplication = applicationInstaller.loadApplication();
            this.updateGlobalLocalizationProvider();
            LOGGER.info("Loaded app:" + applicationInstaller.getApplicationInfo().getName());
            if (applicationInstaller.getApplicationInfo().getErrors().isEmpty()) {
                this.addLoadedApplication(loadedApplication);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error loading application: " + applicationInstaller.getApplicationInfo(), e);
        }
    }

    public void addLoadedApplication(LoadedApplication loadedApplication) {
        this.loadedApplicationMap.put(loadedApplication.getApplication(), loadedApplication);
    }

    public LoadedApplication getLoadedApplication(Application application) {
        return this.loadedApplicationMap.get(application);
    }

    public List<LoadedApplication> getLoadedApplications() {
        return new ArrayList<LoadedApplication>(this.loadedApplicationMap.values());
    }

    public DictionaryLocalizationProvider getDictionary() {
        return this.dictionary;
    }

    public SystemLocalizationProvider getSystemDictionary() {
        return this.systemDictionary;
    }

    public Supplier<DocumentConverter> getDocumentConverterSupplier() {
        return () -> this.documentConverter;
    }

    public SystemConfig getSystemConfig() {
        return (SystemConfig)this.applicationConfig.getConfig();
    }

    public BootstrapSessionHandler getBootstrapSessionHandler() {
        return this.bootstrapSessionHandler;
    }

    public TranslationService getTranslationService() {
        return this.translationService;
    }

    public BaseResourceLinkProvider getBaseResourceLinkProvider() {
        return this.baseResourceLinkProvider;
    }

    public SessionRegistryHandler getSessionRegistryHandler() {
        return this.sessionRegistryHandler;
    }

    public void setSessionRegistryHandler(SessionRegistryHandler sessionRegistryHandler) {
        this.sessionRegistryHandler = sessionRegistryHandler;
    }

    public GlobalLocalizationProvider getGlobalLocalizationProvider() {
        return this.globalLocalizationProvider;
    }

    public void addAuthenticationHandler(AuthenticationHandler authenticationHandler) {
        this.authenticationHandlers.add(authenticationHandler);
    }

    public List<AuthenticationHandler> getAuthenticationHandlers() {
        return this.authenticationHandlers;
    }
}

